/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class ModelUtils {
    public static Vec3 getModelPosition(Entity entity, float yaw, List<ModelPart> parts) {
        double d;
        PoseStack stack = new PoseStack();
        stack.translate(entity.getX(), entity.getY(), entity.getZ());
        stack.mulPose(new Quaternionf().rotationY((-yaw + 180.0f) * ((float)Math.PI / 180)));
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0f, -1.5f, 0.0f);
        for (ModelPart part : parts) {
            part.translateAndRotate(stack);
        }
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)stack.last().pose());
        Vec3 pos = new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
        Vec3 subtract = pos.subtract(entity.position());
        Vec3 vec3 = entity.position();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            d = living.getScale();
        } else {
            d = 1.0;
        }
        return vec3.add(subtract.scale(d));
    }
}

