/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.screen.widget;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.util.ESGuiUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrestPageButton
extends Button {
    private static final ResourceLocation NEXT_PAGE_ENABLED = EternalStarlight.id("textures/gui/screen/crest_selection/next_page_enabled.png");
    private static final ResourceLocation PREVIOUS_PAGE_ENABLED = EternalStarlight.id("textures/gui/screen/crest_selection/previous_page_enabled.png");
    private static final ResourceLocation NEXT_PAGE = EternalStarlight.id("textures/gui/screen/crest_selection/next_page.png");
    private static final ResourceLocation PREVIOUS_PAGE = EternalStarlight.id("textures/gui/screen/crest_selection/previous_page.png");
    private final boolean nextPage;
    private int prevHoverProgress;
    private int hoverProgress;

    public CrestPageButton(int x, int y, int width, int height, boolean nextPage, Component component, Button.OnPress onPress) {
        super(x, y, width, height, component, onPress, DEFAULT_NARRATION);
        this.nextPage = nextPage;
    }

    public void tick() {
        this.prevHoverProgress = this.hoverProgress;
        if (this.isHovered()) {
            if (this.hoverProgress < 5) {
                ++this.hoverProgress;
            }
        } else if (this.hoverProgress > 0) {
            --this.hoverProgress;
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
        float progress = Mth.lerp((float)partialTicks, (float)this.prevHoverProgress, (float)this.hoverProgress) / 40.0f + 1.0f;
        float width = (float)this.getWidth() * progress;
        float height = (float)this.getHeight() * progress;
        ESGuiUtil.blit(guiGraphics, this.active ? (this.nextPage ? NEXT_PAGE_ENABLED : PREVIOUS_PAGE_ENABLED) : (this.nextPage ? NEXT_PAGE : PREVIOUS_PAGE), (float)this.getX() - (width - (float)this.getWidth()) / 2.0f, (float)this.getY() - (height - (float)this.getHeight()) / 2.0f, width, height, width, height);
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

