/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.entity.TorreyaCampfireBlockEntity;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TorreyaCampfireBlock
extends CampfireBlock {
    public static final BooleanProperty STARFIRE = BooleanProperty.create((String)"starfire");

    public TorreyaCampfireBlock(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties) {
        super(spawnParticles, fireDamage, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STARFIRE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TorreyaCampfireBlockEntity(blockPos, blockState);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(ESItems.STARFIRE.get()) && !((Boolean)state.getValue((Property)STARFIRE)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STARFIRE, (Comparable)Boolean.valueOf(true)));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return (Boolean)blockState.getValue((Property)LIT) != false ? TorreyaCampfireBlock.createTickerHelper(blockEntityType, ESBlockEntities.TORREYA_CAMPFIRE.get(), CampfireBlockEntity::particleTick) : null;
        }
        return TorreyaCampfireBlock.createTickerHelper(blockEntityType, ESBlockEntities.TORREYA_CAMPFIRE.get(), TorreyaCampfireBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STARFIRE});
        super.createBlockStateDefinition(builder);
    }
}

