/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.SpiralKelpBlock;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpiralKelpPlantBlock
extends GrowingPlantBodyBlock
implements LiquidBlockContainer {
    public static final MapCodec<SpiralKelpPlantBlock> CODEC = SpiralKelpPlantBlock.simpleCodec(SpiralKelpPlantBlock::new);

    public SpiralKelpPlantBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SpiralKelpBlock.SHAPE, false);
    }

    protected MapCodec<SpiralKelpPlantBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return ESItems.SPIRAL_KELP.get().getDefaultInstance();
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return ESBlocks.SPIRAL_KELP.get();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos());
        return fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8 ? super.getStateForPlacement(blockPlaceContext) : null;
    }

    public FluidState getFluidState(BlockState blockState) {
        return Fluids.WATER.getSource(false);
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        BlockPos blockPos2;
        BlockState blockState2;
        super.animateTick(blockState, level, blockPos, randomSource);
        if (randomSource.nextInt(10) == 0 && !SpiralKelpPlantBlock.isFaceFull((VoxelShape)(blockState2 = level.getBlockState(blockPos2 = blockPos.below())).getCollisionShape((BlockGetter)level, blockPos2), (Direction)Direction.UP)) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)blockPos, (RandomSource)randomSource, (ParticleOptions)((ParticleOptions)ESParticles.SPIRAL_KELP_LEAVES.get()));
        }
    }
}

