/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.LumenstemBlock;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class LumenstemPlantBlock
extends GrowingPlantBodyBlock
implements LiquidBlockContainer {
    public static final MapCodec<LumenstemPlantBlock> CODEC = LumenstemPlantBlock.simpleCodec(LumenstemPlantBlock::new);
    public static final EnumProperty<LumenstemState> LUMENSTEM_STATE = EnumProperty.create((String)"lumenstem_state", LumenstemState.class);

    public LumenstemPlantBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, LumenstemBlock.SHAPE, false);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(LUMENSTEM_STATE, (Comparable)((Object)LumenstemState.MIDDLE)));
    }

    protected MapCodec<LumenstemPlantBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return ESItems.LUMENSTEM.get().getDefaultInstance();
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        return ESBlocks.LUMENSTEM.get();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8 ? this.getSuitableState(super.getStateForPlacement(context), (LevelReader)context.getLevel(), context.getClickedPos()) : null;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.getSuitableState(super.updateShape(state, direction, neighborState, level, pos, neighborPos), (LevelReader)level, pos);
    }

    private BlockState getSuitableState(BlockState state, LevelReader level, BlockPos pos) {
        if (state == null) {
            return null;
        }
        BlockState upper = level.getBlockState(pos.relative(this.growthDirection));
        BlockState lower = level.getBlockState(pos.relative(this.growthDirection.getOpposite()));
        if (upper.is((Block)this.getHeadBlock()) && lower.is((Block)this)) {
            return (BlockState)state.setValue(LUMENSTEM_STATE, (Comparable)((Object)LumenstemState.TOP));
        }
        if (upper.is((Block)this) && lower.is((Block)this)) {
            return (BlockState)state.setValue(LUMENSTEM_STATE, (Comparable)((Object)LumenstemState.MIDDLE));
        }
        if (upper.is((Block)this) && !lower.is((Block)this)) {
            return (BlockState)state.setValue(LUMENSTEM_STATE, (Comparable)((Object)LumenstemState.BOTTOM));
        }
        if (upper.is((Block)this.getHeadBlock()) && !lower.is((Block)this)) {
            return (BlockState)state.setValue(LUMENSTEM_STATE, (Comparable)((Object)LumenstemState.SINGLE));
        }
        return state;
    }

    public FluidState getFluidState(BlockState blockState) {
        return Fluids.WATER.getSource(false);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LUMENSTEM_STATE});
    }

    public static enum LumenstemState implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom"),
        SINGLE("single");

        private final String name;

        private LumenstemState(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

