/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class JinglestemLogBlock
extends RotatedPillarBlock
implements BonemealableBlock {
    public static final MapCodec<JinglestemLogBlock> CODEC = JinglestemLogBlock.simpleCodec(JinglestemLogBlock::new);

    public JinglestemLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<JinglestemLogBlock> codec() {
        return CODEC;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!level.getBlockState(pos.relative(direction)).is(Blocks.WATER)) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        ArrayList<Direction> dirs = new ArrayList<Direction>(Arrays.stream(Direction.values()).toList());
        Util.shuffle(dirs, (RandomSource)random);
        for (Direction direction : dirs) {
            BlockPos placePos = pos.relative(direction);
            if (!level.getBlockState(placePos).is(Blocks.WATER)) continue;
            if (direction == Direction.DOWN) {
                level.setBlockAndUpdate(placePos, ESBlocks.HANGING_ALGALEAVES.get().defaultBlockState());
            } else {
                level.setBlockAndUpdate(placePos, (BlockState)((BlockState)ESBlocks.ALGALEAVES.get().defaultBlockState().setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
            }
            return;
        }
    }
}

