/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.entity.DuskLightBlockEntity;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DuskLightBlock
extends BaseEntityBlock {
    public static final MapCodec<DuskLightBlock> CODEC = DuskLightBlock.simpleCodec(DuskLightBlock::new);

    public DuskLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<DuskLightBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        DuskLightBlockEntity entity;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof DuskLightBlockEntity && (entity = (DuskLightBlockEntity)blockEntity).isLit()) {
            if (!level.isClientSide) {
                entity.setFacing();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DuskLightBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return DuskLightBlock.createTickerHelper(blockEntityType, ESBlockEntities.DUSK_LIGHT.get(), DuskLightBlockEntity::tick);
    }
}

