/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command.text;

import dan200.computercraft.shared.computer.core.ServerComputer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jspecify.annotations.Nullable;

public final class ChatHelpers {
    private static final ChatFormatting HEADER = ChatFormatting.LIGHT_PURPLE;

    private ChatHelpers() {
    }

    public static MutableComponent coloured(@Nullable String text, ChatFormatting colour) {
        return ChatHelpers.text(text).withStyle(colour);
    }

    public static MutableComponent text(@Nullable String text) {
        return Component.literal((String)(text == null ? "" : text));
    }

    public static MutableComponent list(Component ... children) {
        MutableComponent component = Component.empty();
        for (Component child : children) {
            component.append(child);
        }
        return component;
    }

    public static MutableComponent position(BlockPos pos) {
        return Component.literal((String)pos.toShortString());
    }

    public static MutableComponent bool(boolean value) {
        return value ? Component.translatable((String)"commands.computercraft.generic.yes").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"commands.computercraft.generic.no").withStyle(ChatFormatting.RED);
    }

    public static Component link(MutableComponent component, String command, Component toolTip) {
        return ChatHelpers.link((Component)component, new ClickEvent(ClickEvent.Action.RUN_COMMAND, command), toolTip);
    }

    public static Component clientLink(MutableComponent component, String command, Component toolTip) {
        return ChatHelpers.link((Component)component, new ClickEvent(ClickEvent.Action.RUN_COMMAND, command), toolTip);
    }

    public static Component link(Component component, ClickEvent click, Component toolTip) {
        Style style = component.getStyle();
        if (style.getColor() == null) {
            style = style.withColor(ChatFormatting.YELLOW);
        }
        style = style.withClickEvent(click);
        style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)toolTip));
        return component.copy().withStyle(style);
    }

    public static MutableComponent header(String text) {
        return ChatHelpers.coloured(text, HEADER);
    }

    public static MutableComponent copy(String text) {
        return Component.literal((String)text).withStyle(s -> s.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"gui.computercraft.tooltip.copy"))));
    }

    public static String makeComputerCommand(String command, ServerComputer computer) {
        return String.format("/computercraft %s @c[instance=%s]", command, computer.getInstanceUUID());
    }

    public static Component makeComputerDumpCommand(ServerComputer computer) {
        return ChatHelpers.link(ChatHelpers.text("#" + computer.getID()), ChatHelpers.makeComputerCommand("dump", computer), (Component)Component.translatable((String)"commands.computercraft.dump.action"));
    }
}

