/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.crafting.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.BaseRecipe;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.crafting.CraftingModule;
import mcjty.rftoolsbase.modules.crafting.data.CraftingCardData;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardContainer;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class CraftingCardItem
extends Item
implements ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/craftingcard");
    private static CraftingInput CRAFTING_INVENTORY = CraftingInput.of((int)3, (int)3, CraftingCardItem.createList());
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
        ItemStack result = CraftingCardItem.getResult(stack);
        if (!result.isEmpty()) {
            if (result.getCount() > 1) {
                return result.getHoverName().getString() + "(" + result.getCount() + ")";
            }
            return result.getHoverName().getString();
        }
        return "<empty>";
    })}));

    private static List<ItemStack> createList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            list.add(ItemStack.EMPTY);
        }
        return list;
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public CraftingCardItem() {
        super(RFToolsBase.setup.defaultProperties().stacksTo(8));
    }

    @Nullable
    private static Recipe<?> findRecipeInternal(Level world, CraftingInput inv, RecipeType<?> type) {
        for (RecipeHolder rh : world.getRecipeManager().getRecipes()) {
            Recipe r = rh.value();
            if (r == null || !type.equals((Object)r.getType()) || !CraftingCardItem.recipeMatch(r, inv, world)) continue;
            return r;
        }
        return null;
    }

    private static <T extends RecipeInput> boolean recipeMatch(Recipe<T> r, T inv, Level world) {
        return r.matches(inv, world);
    }

    @Nullable
    public static Recipe findRecipe(Level world, ItemStack craftingCard, RecipeType<?> type) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(9);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idxCard = y * 5 + x;
                list.add((ItemStack)stacks.get(idxCard));
            }
        }
        CRAFTING_INVENTORY = CraftingInput.of((int)3, (int)3, list);
        return CraftingCardItem.findRecipeInternal(world, CRAFTING_INVENTORY, type);
    }

    public static void testRecipe(Level world, ItemStack craftingCard) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(9);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idxCard = y * 5 + x;
                list.add((ItemStack)stacks.get(idxCard));
            }
        }
        CRAFTING_INVENTORY = CraftingInput.of((int)3, (int)3, list);
        Recipe<?> recipe = CraftingCardItem.findRecipeInternal(world, CRAFTING_INVENTORY, RecipeType.CRAFTING);
        if (recipe != null) {
            ItemStack stack = BaseRecipe.assemble(recipe, (RecipeInput)CRAFTING_INVENTORY, (Level)world);
            stacks.set(20, (Object)stack);
        } else {
            stacks.set(20, (Object)ItemStack.EMPTY);
        }
        CraftingCardItem.putStacksInItem(craftingCard, stacks);
    }

    private static CraftingCardData defaultData() {
        ItemStackList stacks = ItemStackList.create((int)21);
        Collections.fill(stacks, ItemStack.EMPTY);
        return new CraftingCardData((List<ItemStack>)stacks);
    }

    public static ItemStackList getStacksFromItem(ItemStack craftingCard) {
        CraftingCardData data = (CraftingCardData)craftingCard.getOrDefault(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData());
        ItemStackList stacks = ItemStackList.create((int)21);
        for (int i = 0; i < stacks.size(); ++i) {
            if (i < data.stacks().size()) {
                stacks.set(i, (Object)data.stacks().get(i));
                continue;
            }
            stacks.set(i, (Object)ItemStack.EMPTY);
        }
        return stacks;
    }

    public static void putStacksInItem(ItemStack craftingCard, ItemStackList stacks) {
        craftingCard.update(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData(), data -> {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(data.stacks());
            for (int i = 0; i < list.size(); ++i) {
                if (i < stacks.size()) {
                    list.set(i, (ItemStack)stacks.get(i));
                    continue;
                }
                list.add(ItemStack.EMPTY);
            }
            data = data.withStacks(list);
            return data;
        });
    }

    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext context, @Nonnull List<Component> list, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, list, flagIn);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (!world.isClientSide) {
            player.openMenu(new MenuProvider(this){

                @Nonnull
                public Component getDisplayName() {
                    return ComponentFactory.literal((String)"Crafting Card");
                }

                public AbstractContainerMenu createMenu(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
                    CraftingCardContainer container = new CraftingCardContainer(id, player.blockPosition(), player);
                    container.setupInventories(null, playerInventory);
                    return container;
                }
            });
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static ItemStack getResult(ItemStack card) {
        CraftingCardData data = (CraftingCardData)card.getOrDefault(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData());
        return data.stacks().get(20);
    }

    private static boolean isInGrid(int index) {
        int x = index % 5;
        int y = index / 5;
        return x <= 2 && y <= 2;
    }

    public static boolean fitsGrid(ItemStack card) {
        CraftingCardData data = (CraftingCardData)card.getOrDefault(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData());
        for (int i = 0; i < data.stacks().size(); ++i) {
            if (i >= 20 || CraftingCardItem.isInGrid(i)) continue;
            return false;
        }
        return true;
    }

    public static List<Ingredient> getIngredientsGrid(ItemStack card) {
        CraftingCardData data = (CraftingCardData)card.getOrDefault(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData());
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (int i = 0; i < data.stacks().size(); ++i) {
            if (i >= 20 || !CraftingCardItem.isInGrid(i)) continue;
            stacks.add(Ingredient.of((ItemStack[])new ItemStack[]{data.stacks().get(i)}));
        }
        return stacks;
    }

    public static List<ItemStack> getIngredientStacks(ItemStack card) {
        CraftingCardData data = (CraftingCardData)card.getOrDefault(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < data.stacks().size(); ++i) {
            if (i >= 20 || !CraftingCardItem.isInGrid(i)) continue;
            stacks.add(data.stacks().get(i));
        }
        return stacks;
    }

    public static List<Ingredient> getIngredients(ItemStack card) {
        CraftingCardData data = (CraftingCardData)card.getOrDefault(CraftingModule.ITEM_CRAFTINGCARD_DATA, (Object)CraftingCardItem.defaultData());
        ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
        for (int i = 0; i < data.stacks().size(); ++i) {
            if (i >= 20) continue;
            stacks.add(Ingredient.of((ItemStack[])new ItemStack[]{data.stacks().get(i)}));
        }
        return stacks;
    }
}

