/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.schema;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.kubejs.schema.RecipeSchemaFinder;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.Nullable;

public class CodecParsedListener {
    public static final ThreadLocal<Boolean> enabled = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void codecParsed(Event event) {
        if (!enabled.get().booleanValue()) {
            return;
        }
        Map mapSerializer = RecipeSchemaFinder.serializerEventMap.computeIfAbsent(RecipeSchemaFinder.currentSerializer, k -> new HashMap());
        Set set = mapSerializer.computeIfAbsent(RecipeSchemaFinder.currentRecipe, k -> new LinkedHashSet());
        set.add(event);
    }

    public static Class<?> getParentClass(Event event) {
        return Accessor.PARENT_CLASS.get(event);
    }

    public static String getName(Event event) {
        return Accessor.NAME.get(event);
    }

    @Nullable
    public static JsonElement getInput(Event event) {
        return Accessor.INPUT.get(event);
    }

    public static DataResult<?> getResult(Event event) {
        return Accessor.RESULT.get(event);
    }

    public static void setResult(Event event, DataResult<?> result) {
        try {
            Accessor.RESULT.set(event, result);
        }
        catch (Throwable e) {
            KubeJSTweaks.LOGGER.error("Failed to update result on event", e);
        }
    }

    public static int getDepth(Event event) {
        return Accessor.DEPTH.get(event);
    }

    public static Decoder<?> getDecoder(Event event) {
        return Accessor.DECODER.get(event);
    }

    private static class Accessor {
        private static final VarHandle PARENT_CLASS;
        private static final VarHandle DECODER;
        private static final VarHandle NAME;
        private static final VarHandle INPUT;
        private static final VarHandle RESULT;
        private static final VarHandle DEPTH;

        private Accessor() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.mojang.serialization.Decoder$CodecParsedEvent");
                MethodHandles.Lookup lookup = MethodHandles.publicLookup();
                PARENT_CLASS = lookup.unreflectVarHandle(clazz.getDeclaredField("parentClass"));
                DECODER = lookup.unreflectVarHandle(clazz.getDeclaredField("decoder"));
                NAME = lookup.unreflectVarHandle(clazz.getDeclaredField("name"));
                INPUT = lookup.unreflectVarHandle(clazz.getDeclaredField("input"));
                RESULT = lookup.findVarHandle(clazz, "result", DataResult.class);
                DEPTH = lookup.unreflectVarHandle(clazz.getDeclaredField("depth"));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

