/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.debug;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.event.ClientEvents;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public record DumpErroringRecipes(Throwable exception, ResourceLocation recipeId, JsonElement json) {
    private static final List<DumpErroringRecipes> RECIPES = new ArrayList<DumpErroringRecipes>();
    private static final Path MARKDOWN = KubeJSTweaks.getLocal().resolve("erroring_recipes.md");
    private static boolean dumpErroringRecipes = false;

    public static void enable() {
        dumpErroringRecipes = true;
    }

    public static void disable() {
        DumpErroringRecipes.clear();
        dumpErroringRecipes = false;
    }

    public static boolean isEnabled() {
        return dumpErroringRecipes;
    }

    public static void add(Throwable exception, ResourceLocation recipeId, JsonElement json) {
        if (DumpErroringRecipes.isEnabled()) {
            RECIPES.add(new DumpErroringRecipes(exception, recipeId, json));
        }
    }

    private static void clear() {
        RECIPES.clear();
    }

    public static List<DumpErroringRecipes> getRecipes() {
        return RECIPES;
    }

    public static void dumpToJsonFiles() throws IOException {
        String markDownText = DumpErroringRecipes.generateMarkdown();
        Files.createDirectories(MARKDOWN.getParent(), new FileAttribute[0]);
        Files.writeString(MARKDOWN, (CharSequence)markDownText, new OpenOption[0]);
    }

    private static String generateMarkdown() {
        StringBuilder sb = new StringBuilder();
        ArrayListMultimap summary = ArrayListMultimap.create();
        RECIPES.forEach(recipe -> summary.put((Object)recipe.exception().getMessage(), recipe));
        List<String> sortedCat = summary.keySet().stream().sorted().toList();
        DumpErroringRecipes.generateTableOfContents(sb, sortedCat);
        ResourceManager resourceManager = ServerLifecycleHooks.getCurrentServer().getResourceManager();
        sortedCat.forEach(cat -> {
            summary.get(cat).sort(Comparator.comparing(val -> {
                if (val != null) {
                    return val.recipeId().toString();
                }
                return null;
            }, (val1, val2) -> {
                if (val1 != null && val2 != null) {
                    return val1.compareTo((String)val2);
                }
                return 0;
            }));
            sb.append("##### `").append((String)cat).append("`\n");
            sb.append("\n");
            summary.get(cat).forEach(dump -> {
                KubeRuntimeException kre;
                String firstPart;
                sb.append("<details>\n");
                sb.append("<summary>").append(dump.recipeId().toString()).append("</summary>\n");
                sb.append("\n");
                Throwable patt0$temp = dump.exception();
                if (patt0$temp instanceof KubeRuntimeException && (firstPart = (kre = (KubeRuntimeException)patt0$temp).toString().replace((CharSequence)cat, "")).length() > 3) {
                    sb.append("`").append(firstPart.substring(3)).append("`\n\n");
                }
                resourceManager.getResource(dump.recipeId().withPrefix("recipe/").withSuffix(".json")).ifPresent(resource -> sb.append("`").append(resource.sourcePackId()).append("`\n\n"));
                sb.append("```json\n");
                sb.append(DumpErroringRecipes.toPrettyString(dump.json())).append("\n");
                sb.append("```\n");
                sb.append("\n");
                sb.append("</details>\n\n");
            });
        });
        return sb.toString();
    }

    private static void generateTableOfContents(StringBuilder sb, List<String> headers) {
        if (headers.isEmpty()) {
            sb.append("# No errors detected!\n");
            KubeJSTweaks.LOGGER.info("No error was found to be dumped.");
        } else {
            sb.append("# Errors detected\n");
            if (FMLEnvironment.dist.isClient()) {
                LocalPlayer player = Minecraft.getInstance().player;
                HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"kubejstweaks.chat.click_to_open_markdown"));
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_FILE, MARKDOWN.toAbsolutePath().toString());
                MutableComponent clickMessage = Component.translatable((String)"kubejstweaks.chat.click_here").withStyle(style -> style.withClickEvent(clickEvent).withHoverEvent(hoverEvent).withColor(ChatFormatting.GREEN));
                MutableComponent message = Component.translatable((String)"kubejstweaks.debug.erroring_recipes_summary", (Object[])new Object[]{clickMessage}).withStyle(ChatFormatting.WHITE);
                MutableComponent fullMessage = Component.translatable((String)"kubejstweaks.chat.mod_id", (Object[])new Object[]{message}).withStyle(ChatFormatting.YELLOW);
                if (player != null) {
                    player.sendSystemMessage((Component)fullMessage);
                } else {
                    ClientEvents.MESSAGES.offer((Component)fullMessage);
                }
            }
            headers.forEach(header -> sb.append("- [`").append((String)header).append("`](").append(DumpErroringRecipes.toLink(header)).append(")\n"));
            sb.append("\n");
        }
    }

    private static String toLink(String text) {
        return "#" + text.toLowerCase(Locale.ROOT).replaceAll(" ", "-").replaceAll("[^A-Za-z0-9_-]", "");
    }

    static String toPrettyString(JsonElement json) {
        StringWriter writer = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("  ");
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            jsonWriter.setHtmlSafe(false);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        }
        catch (IOException ex) {
            KubeJSTweaks.LOGGER.error("Error while writing JSON", (Throwable)ex);
        }
        return writer.toString();
    }
}

