/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.bugfix.paper_chunk_patches;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.util.SortedArraySet;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SortedArraySet.class})
@RequiresMod(value="!moonrise")
public abstract class SortedArraySetMixin<T>
extends AbstractSet<T> {
    @Shadow
    private int size;
    @Shadow
    private T[] contents;

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        int i = 0;
        int len = this.size;
        Object[] backingArray = this.contents;
        while (true) {
            if (i >= len) {
                return false;
            }
            if (filter.test(backingArray[i])) break;
            ++i;
        }
        int lastIndex = i;
        while (i < len) {
            T curr = backingArray[i];
            if (!filter.test(curr)) {
                backingArray[lastIndex++] = curr;
            }
            ++i;
        }
        Arrays.fill(backingArray, lastIndex, len, null);
        this.size = lastIndex;
        return true;
    }
}

