/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.cloudglass.datagen.server;

import com.mrbysco.cloudglass.registry.CloudRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CloudLootProvider
extends LootTableProvider {
    public CloudLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(CloudBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    private static class CloudBlockLoot
    extends BlockLootSubProvider {
        protected CloudBlockLoot(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            for (DeferredHolder registryObject : CloudRegistry.BLOCKS.getEntries()) {
                this.dropSelf((Block)registryObject.get());
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return CloudRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

