/*
 * Decompiled with CFR 0.152.
 */
package dev.wp.industrialization_overdrive.machines.guicomponents.multiprocessingarraymachineslot;

import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractElectricCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import dev.wp.industrialization_overdrive.IO;
import dev.wp.industrialization_overdrive.IOConfig;
import dev.wp.industrialization_overdrive.IOTags;
import dev.wp.industrialization_overdrive.machines.components.craft.MultiProcessingArrayMachineComponent;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.swedz.tesseract.neoforge.helper.RegistryHelper;

public final class MultiProcessingArrayMachineSlot {
    public static final ResourceLocation ID = IO.id("multi_processing_array_machine_slot");

    public static int getSlotX(MachineGuiParameters guiParameters) {
        return guiParameters.backgroundWidth + 6;
    }

    public static int getSlotY() {
        return 106 - (IOConfig.allowUpgradesInMultiProcessingArray ? 0 : 20);
    }

    public static boolean isMachine(Item item) {
        MachineBlock machineBlock;
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && (block = (machineBlock = (MachineBlock)block).getBlockEntityInstance()) instanceof AbstractElectricCraftingMultiblockBlockEntity) {
            AbstractElectricCraftingMultiblockBlockEntity blockEntity = (AbstractElectricCraftingMultiblockBlockEntity)block;
            return !RegistryHelper.holder((Registry)BuiltInRegistries.ITEM, (Object)item).is(IOTags.Items.MULTI_PROCESSING_ARRAY_BLACKLIST);
        }
        return false;
    }

    public static boolean isMachine(ItemStack stack) {
        return MultiProcessingArrayMachineSlot.isMachine(stack.getItem());
    }

    public static AbstractElectricCraftingMultiblockBlockEntity getMachine(ItemStack itemStack) {
        return (AbstractElectricCraftingMultiblockBlockEntity)((MachineBlock)((BlockItem)itemStack.getItem()).getBlock()).getBlockEntityInstance();
    }

    public static final class Server
    implements GuiComponent.Server<Integer> {
        private final MachineBlockEntity machine;
        private final Supplier<Integer> getMaxMachines;
        private final MultiProcessingArrayMachineComponent machines;

        public Server(MachineBlockEntity machine, Supplier<Integer> getMaxMachines, MultiProcessingArrayMachineComponent machines) {
            this.machine = machine;
            this.getMaxMachines = getMaxMachines;
            this.machines = machines;
        }

        public Integer copyData() {
            return this.getMaxMachines.get();
        }

        public boolean needsSync(Integer cachedData) {
            return !cachedData.equals(this.getMaxMachines.get());
        }

        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            this.writeCurrentData(buf);
        }

        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.getMaxMachines.get().intValue());
        }

        public ResourceLocation getId() {
            return ID;
        }

        public void setupMenu(GuiComponent.MenuFacade menu) {
            menu.addSlotToMenu((Slot)new HackySlot(MultiProcessingArrayMachineSlot.getSlotX(this.machine.guiParams), MultiProcessingArrayMachineSlot.getSlotY()){

                protected ItemStack getRealStack() {
                    return machines.getMachines();
                }

                protected void setRealStack(ItemStack itemStack) {
                    machines.setMachines(machine, itemStack);
                }

                public boolean mayPlace(ItemStack itemStack) {
                    return MultiProcessingArrayMachineSlot.isMachine(itemStack.getItem());
                }

                public int getMaxStackSize() {
                    return getMaxMachines.get();
                }
            }, SlotGroup.CONFIGURABLE_STACKS);
        }
    }
}

