/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.decoration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public record FloorDecoration(BlockStateProvider blockStateProvider, float chance) implements DungeonDecoration
{
    @Override
    public void decorate(DungeonModel model, LevelAccessor world, BlockPos origin, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
        model.blocks.forEach(block -> {
            BlockPos pos = DungeonDecoration.getRotatedBlockPos(block.position.getX(), block.position.getY() + 1, block.position.getZ(), origin, model, piece.rotation);
            if (block.type == DungeonModelBlockType.FLOOR && block.position.getY() < model.height - 1 && worldGenBounds.isInside((Vec3i)pos) && structureBounds.isInside((Vec3i)pos) && !DungeonBuilder.isBlockProtected(world, origin) && world.isEmptyBlock(origin.offset(block.position).above()) && FloorDecoration.checkSolid(world, origin.offset(block.position), worldGenBounds, structureBounds) && random.nextFloat() < this.chance) {
                world.setBlock(pos, this.blockStateProvider.get(world, pos, random), 2);
            }
        });
    }

    private static boolean checkSolid(LevelAccessor world, BlockPos pos, BoundingBox worldGenBounds, BoundingBox structureBounds) {
        return worldGenBounds.isInside((Vec3i)pos) && structureBounds.isInside((Vec3i)pos) && world.getBlockState(pos).canOcclude();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "floor");
        object.addProperty("chance", (Number)Float.valueOf(this.chance));
        object.add("block", (JsonElement)this.blockStateProvider.serialize());
        return object;
    }

    public record NextToSolid(BlockStateProvider blockStateProvider, float chance) implements DungeonDecoration
    {
        @Override
        public void decorate(DungeonModel model, LevelAccessor world, BlockPos origin, RandomSource random, BoundingBox worldGenBounds, BoundingBox structureBounds, DungeonPiece piece) {
            model.blocks.forEach(block -> {
                BlockPos pos;
                if (block.type == DungeonModelBlockType.FLOOR && block.position.getY() < model.height - 1 && worldGenBounds.isInside((Vec3i)(pos = DungeonDecoration.getRotatedBlockPos(block.position.getX(), block.position.getY() + 1, block.position.getZ(), origin, model, piece.rotation))) && structureBounds.isInside((Vec3i)pos) && world.isEmptyBlock(pos) && world.getBlockState(pos.below()).canOcclude() && !DungeonBuilder.isBlockProtected(world, pos) && (FloorDecoration.checkSolid(world, pos.north(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.east(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.south(), worldGenBounds, structureBounds) || FloorDecoration.checkSolid(world, pos.west(), worldGenBounds, structureBounds)) && random.nextFloat() < this.chance) {
                    world.setBlock(pos, this.blockStateProvider.get(world, pos, random), 2);
                }
            });
        }

        @Override
        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", "floor_next_to_solid");
            object.addProperty("chance", (Number)Float.valueOf(this.chance));
            object.add("block", (JsonElement)this.blockStateProvider.serialize());
            return object;
        }
    }
}

