/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.installertools.Task;
import net.neoforged.installertools.util.HashFunction;

public class BundlerExtract
extends Task {
    private static final Attributes.Name FORMAT = new Attributes.Name("Bundler-Format");

    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputO = parser.accepts("input", "The input bundled jar").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output", "Output file if extracting single entry, or output directory").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder allO = parser.accepts("all", "Extract all files from the bundle.");
        OptionSpecBuilder jarOnlyO = parser.accepts("jar-only", "Only extract the main version jar file");
        OptionSpecBuilder librariesO = parser.accepts("libraries", "Only extract the libraries");
        try {
            OptionSet options = parser.parse(args);
            File input = ((File)options.valueOf((OptionSpec)inputO)).getAbsoluteFile();
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            boolean all = options.has((OptionSpec)allO);
            boolean jarOnly = options.has((OptionSpec)jarOnlyO);
            boolean libs = options.has((OptionSpec)librariesO);
            if (all && jarOnly) {
                this.error("Can not specify --all and --jar-only at the same time");
            }
            this.log("Input:   " + input);
            this.log("Output:  " + output);
            this.log("All:     " + all);
            this.log("JarOnly: " + jarOnly);
            this.log("Libs:    " + libs);
            if (!input.exists()) {
                this.error("Could not find input: " + input);
            }
            try (FileSystem fs = FileSystems.newFileSystem(input.toPath(), null);){
                Path mfp = fs.getPath("META-INF", "MANIFEST.MF");
                if (!Files.exists(mfp, new LinkOption[0])) {
                    this.error("Input archive does not contain META-INF/MANIFEST.MF");
                }
                Manifest mf = null;
                try (InputStream is = Files.newInputStream(mfp, new OpenOption[0]);){
                    mf = new Manifest(is);
                }
                String format = mf.getMainAttributes().getValue(FORMAT);
                if (format == null) {
                    this.error("Invalid bundler archive, missing format entry from manifest");
                }
                if (!"1.0".equals(format)) {
                    this.error("Unsupported bundler format " + format + " only 1.0 is supported");
                }
                FileList libraries = FileList.read(fs.getPath("META-INF", "libraries.list"));
                FileList versions = FileList.read(fs.getPath("META-INF", "versions.list"));
                int amount = 0;
                if (jarOnly) {
                    FileList.Entry entry = null;
                    for (FileList.Entry e : versions.entries) {
                        if (!e.path.endsWith(".jar")) continue;
                        entry = e;
                        break;
                    }
                    if (entry == null) {
                        this.error("Could not find main jar in versions.list");
                    }
                    this.extractFile("versions", fs, entry, output);
                } else if (libs) {
                    if (output.exists() && output.isFile()) {
                        this.error("Can not extract to " + output + " as it is a file, not a directory");
                    }
                    PROGRESS.setMaxProgress(libraries.entries.size());
                    for (FileList.Entry entry : libraries.entries) {
                        this.extractFile("libraries", fs, entry, new File(output, entry.path));
                        PROGRESS.setProgress(++amount);
                    }
                } else if (all) {
                    if (output.exists() && output.isFile()) {
                        this.error("Can not extract to " + output + " as it is a file, not a directory");
                    }
                    PROGRESS.setMaxProgress(libraries.entries.size() + versions.entries.size());
                    for (FileList.Entry entry : libraries.entries) {
                        this.extractFile("libraries", fs, entry, new File(output, "libraries/" + entry.path));
                        PROGRESS.setProgress(++amount);
                    }
                    for (FileList.Entry entry : versions.entries) {
                        this.extractFile("versions", fs, entry, new File(output, "versions/" + entry.path));
                        PROGRESS.setProgress(++amount);
                    }
                } else {
                    this.error("Must specify either --jar only, or --all");
                }
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    private void extractFile(String group, FileSystem fs, FileList.Entry entry, File output) throws IOException {
        if (output.exists()) {
            String existing;
            if (output.isDirectory()) {
                this.error("Can not extract main version jar to a directory.");
            }
            if ((existing = HashFunction.SHA256.hash(output)).equals(entry.hash)) {
                this.log("File already exists, and hash verified");
                return;
            }
            this.log("Existing file's hash does not match");
            this.log("Expected: " + entry.hash);
            this.log("Actual:   " + existing);
        }
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        Files.copy(fs.getPath("META-INF", group, entry.path), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String extracted = HashFunction.SHA256.hash(output);
        if (!extracted.equals(entry.hash)) {
            this.error("Failed to extract: " + group + '/' + entry.path + " Hash mismatch\nExpected: " + entry.hash + '\n' + "Actual:   " + extracted);
        } else {
            this.log("Extracted: " + group + '/' + entry.path);
        }
    }

    private static class FileList {
        private final List<Entry> entries;

        private static FileList read(Path path) throws IOException {
            ArrayList<Entry> ret = new ArrayList<Entry>();
            for (String line : Files.readAllLines(path)) {
                String[] pts = line.split("\t");
                if (pts.length != 3) {
                    throw new IllegalStateException("Invalid file list line: " + line);
                }
                ret.add(new Entry(pts[0], pts[1], pts[2]));
            }
            return new FileList(ret);
        }

        private FileList(List<Entry> entries) {
            this.entries = entries;
        }

        private static class Entry {
            private final String hash;
            private final String id;
            private final String path;

            private Entry(String hash, String id, String path) {
                this.hash = hash;
                this.id = id;
                this.path = path;
            }
        }
    }
}

