/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util.potions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import org.apache.commons.lang3.stream.Streams;
import reliquary.item.PotionEssenceItem;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.EffectComparator;
import reliquary.util.potions.PotionIngredient;
import reliquary.util.potions.PotionMap;

public class PotionHelper {
    public static final String EFFECTS_TAG = "effects";
    private static final int MAX_DURATION = 36000;
    private static final int MAX_AMPLIFIER = 4;
    private static final Set<Holder<MobEffect>> nonAugmentableEffects = Set.of(MobEffects.BLINDNESS, MobEffects.CONFUSION, MobEffects.INVISIBILITY, MobEffects.NIGHT_VISION, MobEffects.WATER_BREATHING);

    private PotionHelper() {
    }

    public static boolean isItemEssence(ItemStack stack) {
        return stack.getItem() instanceof PotionEssenceItem;
    }

    public static boolean isIngredient(ItemStack stack) {
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!RegistryHelper.registryNamesEqual(ingredient.getItem().getItem(), stack.getItem())) continue;
            return true;
        }
        return false;
    }

    public static Optional<PotionIngredient> getIngredient(ItemStack stack) {
        if (stack.getItem() instanceof PotionEssenceItem) {
            return Optional.of(new PotionIngredient(stack, Streams.of(PotionHelper.getPotionEffectsFromStack(stack)).toList()));
        }
        for (PotionIngredient ingredient : PotionMap.ingredients) {
            if (!RegistryHelper.registryNamesEqual(ingredient.getItem().getItem(), stack.getItem())) continue;
            return Optional.of(ingredient);
        }
        return Optional.empty();
    }

    private static boolean isAugmentablePotionEffect(MobEffectInstance effect) {
        return !nonAugmentableEffects.contains(effect.getEffect());
    }

    public static void addPotionContentsToCompoundTag(CompoundTag tag, PotionContents potionContents) {
        if (!potionContents.hasEffects()) {
            return;
        }
        tag.put(EFFECTS_TAG, (Tag)DataComponents.POTION_CONTENTS.codec().encode((Object)potionContents, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
    }

    public static void addPotionContentsToStack(ItemStack itemstack, PotionContents potionContents) {
        itemstack.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
    }

    public static void cleanPotionEffects(ItemStack stack) {
        stack.remove(DataComponents.POTION_CONTENTS);
    }

    public static PotionContents changePotionEffectsDuration(PotionContents potionContents, float factor) {
        ArrayList ret = Lists.newArrayList();
        for (MobEffectInstance effect : potionContents.getAllEffects()) {
            int newDuration = (int)(((MobEffect)effect.getEffect().value()).isInstantenous() ? 1.0f : (float)effect.getDuration() * factor);
            ret.add(new MobEffectInstance(effect.getEffect(), newDuration, effect.getAmplifier(), effect.isAmbient(), effect.isVisible()));
        }
        return new PotionContents(potionContents.potion(), potionContents.customColor(), (List)ret);
    }

    public static PotionContents augmentPotionContents(PotionContents potionContents, int redstoneCount, int glowstoneCount) {
        return PotionHelper.addRedstone(PotionHelper.addGlowstone(potionContents, glowstoneCount), redstoneCount);
    }

    private static PotionContents addRedstone(PotionContents potionContents, int redstoneCount) {
        if (redstoneCount <= 0) {
            return potionContents;
        }
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        int effectCnt = Iterables.size((Iterable)potionContents.getAllEffects());
        double multiplier = 1.0;
        for (int redstoneLevel = 1; redstoneLevel <= redstoneCount; ++redstoneLevel) {
            multiplier *= (double)(8 + effectCnt) / (double)(3 + effectCnt) - 1.0 / (double)(3 + effectCnt) * ((double)redstoneLevel - 1.0);
        }
        for (MobEffectInstance effect : potionContents.getAllEffects()) {
            int newDuration = (int)((double)effect.getDuration() * multiplier);
            newDuration = Math.min(newDuration, 72000);
            MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), newDuration, effect.getAmplifier(), effect.isAmbient(), effect.isVisible());
            newEffects.add(newEffect);
        }
        return new PotionContents(potionContents.potion(), potionContents.customColor(), newEffects);
    }

    private static PotionContents addGlowstone(PotionContents potionContents, int glowstoneCount) {
        if (glowstoneCount <= 0) {
            return potionContents;
        }
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        int effectCnt = Iterables.size((Iterable)potionContents.getAllEffects());
        double multiplier = 1.0;
        for (int glowstoneLevel = 1; glowstoneLevel <= glowstoneCount; ++glowstoneLevel) {
            multiplier *= (double)(11 + effectCnt) / (double)(6 + effectCnt) - 1.0 / (double)(6 + effectCnt) * (double)glowstoneLevel - 1.0;
        }
        for (MobEffectInstance effect : potionContents.getAllEffects()) {
            int newAmplifier = effect.getAmplifier();
            if (PotionHelper.isAugmentablePotionEffect(effect)) {
                newAmplifier = Math.min(effect.getAmplifier() + glowstoneCount, 5);
            }
            MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), (int)((double)effect.getDuration() * multiplier), newAmplifier, effect.isAmbient(), effect.isVisible());
            newEffects.add(newEffect);
        }
        return new PotionContents(potionContents.potion(), potionContents.customColor(), newEffects);
    }

    static PotionContents combineIngredients(PotionIngredient ... ingredients) {
        return PotionHelper.combineIngredients(Arrays.asList(ingredients));
    }

    public static PotionContents combineIngredients(Collection<PotionIngredient> ingredients) {
        HashMap potionEffectCounterList = new HashMap();
        HashSet<ResourceKey> potionEffectList = new HashSet<ResourceKey>();
        for (PotionIngredient ingredient : ingredients) {
            for (MobEffectInstance effect : ingredient.getEffects()) {
                if (potionEffectCounterList.containsKey(effect.getEffect().getKey())) {
                    potionEffectList.add(effect.getEffect().getKey());
                    ((List)potionEffectCounterList.get(effect.getEffect().getKey())).add(effect);
                    continue;
                }
                ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
                effects.add(effect);
                potionEffectCounterList.put(effect.getEffect().getKey(), effects);
            }
        }
        ArrayList combinedEffects = Lists.newArrayList();
        for (ResourceKey potionKey : potionEffectList) {
            List effects = (List)potionEffectCounterList.get(potionKey);
            int duration = PotionHelper.getCombinedDuration(effects);
            int amplifier = PotionHelper.getCombinedAmplifier((ResourceKey<MobEffect>)potionKey, effects);
            if (duration == 0) continue;
            BuiltInRegistries.MOB_EFFECT.getHolder(potionKey).ifPresent(mobEffect -> combinedEffects.add(new MobEffectInstance((Holder)mobEffect, duration, amplifier)));
        }
        combinedEffects.sort(new EffectComparator());
        return new PotionContents(Optional.empty(), Optional.empty(), (List)combinedEffects);
    }

    private static int getCombinedAmplifier(ResourceKey<MobEffect> potionKey, List<MobEffectInstance> effects) {
        int amplifier = 0;
        for (MobEffectInstance effect : effects) {
            amplifier += effect.getAmplifier();
        }
        if (!MobEffects.SATURATION.is(potionKey)) {
            amplifier = Math.min(amplifier, 4);
        }
        return amplifier;
    }

    private static int getCombinedDuration(List<MobEffectInstance> effects) {
        int count = 0;
        int duration = 0;
        for (MobEffectInstance effect : effects) {
            if (((MobEffect)effect.getEffect().value()).isInstantenous()) {
                return 1;
            }
            ++count;
            duration += effect.getDuration();
        }
        duration = (int)((double)duration / 1.2);
        if (count == 3) {
            duration = (int)((double)duration / 1.1);
        }
        return Math.min(duration, 36000);
    }

    public static void applyEffectsToEntity(PotionContents potionContents, Entity source, @Nullable Entity indirectSource, LivingEntity livingEntity) {
        PotionHelper.applyEffectsToEntity(potionContents, source, indirectSource, livingEntity, 1.0);
    }

    public static void applyEffectsToEntity(PotionContents potionContents, Entity source, @Nullable Entity indirectSource, LivingEntity livingEntity, double amplifier) {
        potionContents.forEachEffect(effectInstance -> {
            if (((MobEffect)effectInstance.getEffect().value()).isInstantenous()) {
                ((MobEffect)effectInstance.getEffect().value()).applyInstantenousEffect(source, indirectSource, livingEntity, effectInstance.getAmplifier(), amplifier);
            } else {
                int j = (int)(amplifier * (double)effectInstance.getDuration() + 0.5);
                if (j > 20) {
                    livingEntity.addEffect(new MobEffectInstance(effectInstance.getEffect(), j, effectInstance.getAmplifier(), false, false));
                }
            }
        });
    }

    public static PotionContents getPotionContentsFromCompoundTag(CompoundTag tag) {
        if (!tag.contains(EFFECTS_TAG)) {
            return PotionContents.EMPTY;
        }
        return (PotionContents)DataComponents.POTION_CONTENTS.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(EFFECTS_TAG)).getOrThrow();
    }

    public static boolean hasPotionContents(ItemStack stack) {
        return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects();
    }

    public static Iterable<MobEffectInstance> getPotionEffectsFromStack(ItemStack stack) {
        return ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).getAllEffects();
    }
}

