/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import reliquary.item.EnderStaffItem;

public class TooltipBuilder {
    private static Item.TooltipContext context;
    private final List<Component> tooltip;

    public static TooltipBuilder of(List<Component> tooltip, Item.TooltipContext context) {
        TooltipBuilder.context = context;
        return new TooltipBuilder(tooltip);
    }

    private TooltipBuilder(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public void potionEffects(PotionContents potionContents) {
        potionContents.addPotionTooltip(this.tooltip::add, 1.0f, context.tickRate());
    }

    public void potionEffects(ItemStack stack) {
        this.potionEffects((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY));
    }

    public TooltipBuilder itemTooltip(Item item) {
        String langName = item.getDescriptionId() + ".tooltip";
        if (Language.getInstance().has(langName)) {
            this.addTooltipLines(c -> c.withStyle(ChatFormatting.GRAY), item.getDescriptionId() + ".tooltip", new Object[0]);
        }
        return this;
    }

    public TooltipBuilder charge(Item item, String langSuffix, int charge, int chargeLimit) {
        this.tooltip.add((Component)Component.translatable((String)(item.getDescriptionId() + langSuffix), (Object[])new Object[]{Component.literal((String)String.valueOf(charge)).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(chargeLimit)).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder data(Item item, String langSuffix, Object ... args) {
        return this.data(item.getDescriptionId() + langSuffix, args);
    }

    public TooltipBuilder data(String langKey, Object ... args) {
        Object[] components;
        if (args.length > 0) {
            components = new Component[args.length];
            for (Object arg : args) {
                if (arg instanceof Component) {
                    Component argComponent = (Component)arg;
                    components[i] = argComponent;
                    continue;
                }
                components[i] = Component.literal((String)String.valueOf(arg)).withStyle(ChatFormatting.WHITE);
            }
        } else {
            components = new Component[]{};
        }
        this.tooltip.add((Component)Component.translatable((String)langKey, (Object[])components).withStyle(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder charge(Item item, String langSuffix, String chargeName, int charge) {
        this.tooltip.add((Component)Component.translatable((String)(item.getDescriptionId() + langSuffix), (Object[])new Object[]{Component.literal((String)chargeName).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(charge)).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder charge(Item item, String langSuffix, int charge) {
        this.tooltip.add((Component)Component.translatable((String)(item.getDescriptionId() + langSuffix), (Object[])new Object[]{Component.literal((String)String.valueOf(charge)).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.GREEN));
        return this;
    }

    public TooltipBuilder showMoreInfo() {
        if (!Screen.hasShiftDown()) {
            this.tooltip.add((Component)Component.translatable((String)"tooltip.reliquary.hold_for_more_info", (Object[])new Object[]{Component.translatable((String)"tooltip.reliquary.shift").withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.DARK_GRAY));
        }
        return this;
    }

    public TooltipBuilder absorb() {
        this.tooltip.add((Component)Component.translatable((String)"tooltip.reliquary.absorb").withStyle(ChatFormatting.DARK_GRAY));
        return this;
    }

    public TooltipBuilder absorbActive(String itemName) {
        return this.absorbActive((Component)Component.literal((String)itemName).withStyle(ChatFormatting.DARK_AQUA));
    }

    public TooltipBuilder absorbActive(Component thingName) {
        this.tooltip.add((Component)Component.translatable((String)"tooltip.reliquary.absorb_active", (Object[])new Object[]{thingName}).withStyle(ChatFormatting.DARK_GRAY));
        return this;
    }

    public TooltipBuilder description(String langKey, Object ... args) {
        this.addTooltipLines(c -> c.withStyle(ChatFormatting.DARK_GRAY), langKey, args);
        return this;
    }

    public TooltipBuilder description(Item item, String langSuffix, Object ... args) {
        return this.description(item.getDescriptionId() + langSuffix, args);
    }

    public TooltipBuilder warning(EnderStaffItem enderStaffItem, String langSuffix) {
        this.tooltip.add((Component)Component.translatable((String)(enderStaffItem.getDescriptionId() + langSuffix)).withStyle(ChatFormatting.RED));
        return this;
    }

    private void addTooltipLines(UnaryOperator<MutableComponent> applyStyle, String langKey, Object ... args) {
        String[] lines;
        String text = Language.getInstance().getOrDefault(langKey);
        for (String line : lines = text.split("\n")) {
            this.tooltip.add((Component)applyStyle.apply(Component.translatableWithFallback((String)"", (String)line, (Object[])args)));
        }
    }
}

