/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import reliquary.util.PlayerInventoryHandler;

public class PlayerInventoryProvider {
    public static final String MAIN_INVENTORY = "main";
    public static final String OFFHAND_INVENTORY = "offhand";
    public static final String ARMOR_INVENTORY = "armor";
    private final Map<String, PlayerInventoryHandler> playerInventoryHandlers = new LinkedHashMap<String, PlayerInventoryHandler>();
    private final List<String> renderedHandlers = new ArrayList<String>();
    private static final PlayerInventoryProvider serverProvider = new PlayerInventoryProvider();
    private static final PlayerInventoryProvider clientProvider = new PlayerInventoryProvider();

    public static PlayerInventoryProvider get() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return clientProvider;
        }
        return serverProvider;
    }

    private PlayerInventoryProvider() {
        this.addPlayerInventoryHandler(MAIN_INVENTORY, () -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, identifier) -> player.getInventory().items.size(), (player, identifier, slot) -> (ItemStack)player.getInventory().items.get(slot), (player, identifier, slot, stack) -> player.getInventory().setItem(slot, stack), false);
        this.addPlayerInventoryHandler(OFFHAND_INVENTORY, () -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, identifier) -> player.getInventory().offhand.size(), (player, identifier, slot) -> (ItemStack)player.getInventory().offhand.get(slot), (player, identifier, slot, stack) -> player.getInventory().offhand.set(slot, (Object)stack), false);
        this.addPlayerInventoryHandler(ARMOR_INVENTORY, () -> PlayerInventoryHandler.SINGLE_IDENTIFIER, (player, identifier) -> player.getInventory().armor.size(), (player, identifier, slot) -> (ItemStack)player.getInventory().armor.get(slot), (player, identifier, slot, stack) -> player.getInventory().armor.set(slot, (Object)stack), true);
    }

    public void addPlayerInventoryHandler(String name, Supplier<Set<String>> identifiersGetter, PlayerInventoryHandler.SlotCountGetter slotCountGetter, PlayerInventoryHandler.SlotStackGetter slotStackGetter, PlayerInventoryHandler.SlotStackSetter slotStackSetter, boolean rendered) {
        LinkedHashMap<String, PlayerInventoryHandler> temp = new LinkedHashMap<String, PlayerInventoryHandler>(this.playerInventoryHandlers);
        this.playerInventoryHandlers.clear();
        this.playerInventoryHandlers.put(name, new PlayerInventoryHandler(identifiersGetter, slotCountGetter, slotStackGetter, slotStackSetter));
        this.playerInventoryHandlers.putAll(temp);
        if (rendered) {
            ArrayList<String> tempRendered = new ArrayList<String>(this.renderedHandlers);
            this.renderedHandlers.clear();
            this.renderedHandlers.add(name);
            this.renderedHandlers.addAll(tempRendered);
        }
    }

    private Map<String, PlayerInventoryHandler> getPlayerInventoryHandlers() {
        return this.playerInventoryHandlers;
    }

    public void runOnPlayerInventoryHandlers(Player player, Consumer<ItemStack> run) {
        this.getFromPlayerInventoryHandlers(player, (stack, result) -> {
            run.accept((ItemStack)stack);
            return result;
        }, result -> false, () -> true);
    }

    public void swapFirstFoundItemInPlayerInventoryHandlers(Player player, Item filter, ItemStack replacement) {
        for (PlayerInventoryHandler handler : this.playerInventoryHandlers.values()) {
            Set<String> identifiers = handler.getIdentifiers();
            for (String identifier : identifiers) {
                int slots = handler.getSlotCount(player, identifier);
                for (int slot = 0; slot < slots; ++slot) {
                    ItemStack stack = handler.getStackInSlot(player, identifier, slot);
                    if (stack.getItem() != filter) continue;
                    handler.setStackInSlot(player, identifier, slot, replacement);
                    return;
                }
            }
        }
    }

    public <T> T getFromPlayerInventoryHandlers(Player player, BiFunction<ItemStack, T, T> get, Predicate<T> shouldExit, Supplier<T> defaultValue) {
        T result = defaultValue.get();
        for (PlayerInventoryHandler handler : this.playerInventoryHandlers.values()) {
            Set<String> identifiers = handler.getIdentifiers();
            for (String identifier : identifiers) {
                int slots = handler.getSlotCount(player, identifier);
                for (int slot = 0; slot < slots; ++slot) {
                    result = get.apply(handler.getStackInSlot(player, identifier, slot), (ItemStack)result);
                    if (!shouldExit.test(result)) continue;
                    return result;
                }
            }
        }
        return result;
    }
}

