/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.reference.Config;

public class PedestalMeleeWeaponWrapper
implements IPedestalActionItemWrapper {
    private final int cooldownAfterSwing;

    public PedestalMeleeWeaponWrapper() {
        this.cooldownAfterSwing = (Integer)Config.COMMON.blocks.pedestal.meleeWrapperCooldown.get();
    }

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        BlockPos pos = pedestal.getBlockPosition();
        int meleeRange = (Integer)Config.COMMON.blocks.pedestal.meleeWrapperRange.get();
        List entities = level.getEntitiesOfClass(Mob.class, new AABB((double)pos.getX() - (double)meleeRange, (double)pos.getY() - (double)meleeRange, (double)pos.getZ() - (double)meleeRange, (double)pos.getX() + (double)meleeRange, (double)pos.getY() + (double)meleeRange, (double)pos.getZ() + (double)meleeRange));
        if (entities.isEmpty()) {
            pedestal.setActionCoolDown(40);
            return;
        }
        Mob entityToAttack = (Mob)entities.get(level.random.nextInt(entities.size()));
        while (!entities.isEmpty() && !this.canAttackEntity(entityToAttack)) {
            entities.remove(entityToAttack);
            if (entities.isEmpty()) continue;
            entityToAttack = (Mob)entities.get(level.random.nextInt(entities.size()));
        }
        if (entities.isEmpty()) {
            pedestal.setActionCoolDown(40);
            return;
        }
        Mob finalEntityToAttack = entityToAttack;
        pedestal.getFakePlayer().ifPresent(fakePlayer -> this.attackEntity(stack, pedestal, pos, finalEntityToAttack, (FakePlayer)fakePlayer));
        if (stack.isEmpty()) {
            pedestal.destroyItem();
        }
    }

    private void attackEntity(ItemStack stack, IPedestal pedestal, BlockPos pos, Mob entityToAttack, FakePlayer fakePlayer) {
        fakePlayer.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
        fakePlayer.tick();
        fakePlayer.attack((Entity)entityToAttack);
        entityToAttack.setLastHurtByMob(null);
        pedestal.setActionCoolDown((int)fakePlayer.getCurrentItemAttackStrengthDelay() + this.cooldownAfterSwing);
    }

    private boolean canAttackEntity(Mob entityToAttack) {
        TamableAnimal tamableAnimal;
        Horse horse;
        return !(entityToAttack instanceof Villager || entityToAttack instanceof Animal && entityToAttack.isBaby() || entityToAttack instanceof Horse && (horse = (Horse)entityToAttack).isTamed() || entityToAttack instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entityToAttack).isTame());
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }
}

