/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.BlockGetter;
import reliquary.Reliquary;
import reliquary.api.IPedestal;
import reliquary.client.render.PedestalFishHookRenderer;
import reliquary.util.WorldHelper;

public record PedestalFishHookPayload(BlockPos pedestalPos, double hookX, double hookY, double hookZ) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PedestalFishHookPayload> TYPE = new CustomPacketPayload.Type(Reliquary.getRL("pedestal_fish_hook"));
    public static final StreamCodec<FriendlyByteBuf, PedestalFishHookPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PedestalFishHookPayload::pedestalPos, (StreamCodec)ByteBufCodecs.DOUBLE, PedestalFishHookPayload::hookX, (StreamCodec)ByteBufCodecs.DOUBLE, PedestalFishHookPayload::hookY, (StreamCodec)ByteBufCodecs.DOUBLE, PedestalFishHookPayload::hookZ, PedestalFishHookPayload::new);

    public static void handlePayload(PedestalFishHookPayload payload) {
        ClientLevel level = Minecraft.getInstance().level;
        WorldHelper.getBlockEntity((BlockGetter)level, payload.pedestalPos, IPedestal.class).ifPresent(pedestal -> {
            PedestalFishHookRenderer.HookRenderingData data = null;
            if (payload.hookY > 0.0) {
                data = new PedestalFishHookRenderer.HookRenderingData(payload.hookX, payload.hookY, payload.hookZ);
            }
            pedestal.setItemData(data);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

