/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.potion;

import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import reliquary.entity.potion.ThrownPotionBase;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.reference.Colors;

public class AphroditePotion
extends ThrownPotionBase {
    public AphroditePotion(EntityType<? extends AphroditePotion> entityType, Level level) {
        super(entityType, level, new ItemStack((ItemLike)ModItems.APHRODITE_POTION.get()));
    }

    public AphroditePotion(Level level, Player player) {
        super(ModEntities.APHRODITE_POTION.get(), level, player, new ItemStack((ItemLike)ModItems.APHRODITE_POTION.get()));
    }

    public AphroditePotion(Level level, Position position) {
        super(ModEntities.APHRODITE_POTION.get(), level, position.x(), position.y(), position.z(), new ItemStack((ItemLike)ModItems.APHRODITE_POTION.get()));
    }

    @Override
    boolean hasLivingEntityEffect() {
        return true;
    }

    @Override
    void doGroundSplashEffect() {
    }

    @Override
    void doLivingSplashEffect(LivingEntity el) {
        if (!(el instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)el;
        if (animal.getAge() != 0) {
            return;
        }
        Entity thrower = this.getOwner();
        if (thrower instanceof Player) {
            Player player = (Player)thrower;
            animal.setInLove(player);
        } else {
            animal.setInLove(null);
        }
        for (int var3 = 0; var3 < 7; ++var3) {
            double var4 = this.random.nextGaussian() * 0.02;
            double var6 = this.random.nextGaussian() * 0.02;
            double var8 = this.random.nextGaussian() * 0.02;
            this.level().addParticle((ParticleOptions)ParticleTypes.HEART, animal.getX() + (double)(this.random.nextFloat() * animal.getBbWidth() * 2.0f) - (double)animal.getBbWidth(), animal.getY() + 0.5 + (double)(this.random.nextFloat() * animal.getBbHeight()), animal.getZ() + (double)(this.random.nextFloat() * animal.getBbWidth() * 2.0f) - (double)animal.getBbWidth(), var4, var6, var8);
        }
    }

    @Override
    int getColor() {
        return Colors.get("CC3024");
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)ModItems.APHRODITE_POTION.get());
    }
}

