/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.network.SpawnThrownPotionImpactParticlesPayload;
import reliquary.reference.Colors;

public class GlowingWater
extends ThrowableProjectile
implements ItemSupplier {
    public GlowingWater(EntityType<GlowingWater> entityType, Level level) {
        super(entityType, level);
    }

    public GlowingWater(Level level, Player player) {
        super(ModEntities.GLOWING_WATER.get(), (LivingEntity)player, level);
    }

    public GlowingWater(Level level, Position position) {
        super(ModEntities.GLOWING_WATER.get(), position.x(), position.y(), position.z(), level);
    }

    protected double getDefaultGravity() {
        return 0.05f;
    }

    private boolean isUndead(LivingEntity e) {
        return e.getType().is(EntityTypeTags.UNDEAD);
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            this.spawnParticles();
            AABB bb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
            List eList = this.level().getEntitiesOfClass(Mob.class, bb);
            eList.stream().filter(this::isUndead).forEach(e -> {
                float amount = 18.0f + (float)this.random.nextInt(17);
                Entity thrower = this.getOwner();
                if (thrower instanceof Player) {
                    Player player = (Player)thrower;
                    e.hurt(this.damageSources().playerAttack(player), amount);
                } else {
                    e.hurt(this.damageSources().magic(), amount);
                }
            });
            this.level().levelEvent(2002, this.blockPosition(), 0);
            this.discard();
        }
    }

    private void spawnParticles() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        ItemParticleOption itemParticleData = new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)ModItems.GLOWING_WATER.get()));
        for (int particleNum = 0; particleNum < 8; ++particleNum) {
            this.level().addParticle((ParticleOptions)itemParticleData, x, y, z, this.random.nextGaussian() * 0.15, this.random.nextDouble() * 0.2, this.random.nextGaussian() * 0.15);
        }
        this.level().playSound(null, this.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL, 1.0f, this.level().random.nextFloat() * 0.1f + 0.9f);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SpawnThrownPotionImpactParticlesPayload(Colors.get("3B64DC"), this.getX(), this.getY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)ModItems.GLOWING_WATER.get());
    }
}

