/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.network.SpawnConcussiveExplosionParticlesPayload;
import reliquary.util.RandHelper;

public class ConcussiveExplosion
extends Explosion {
    private final Level level;
    private final Vec3 pos;
    protected final Entity exploder;
    private float explosionSize;
    private final Map<Player, Vec3> playerKnockbackMap;
    private final Player shootingEntity;

    public ConcussiveExplosion(Level level, @Nullable Entity entity, @Nullable Player player, Vec3 pos, float size, boolean isFlaming) {
        super(level, entity, null, null, pos.x(), pos.y(), pos.z(), size, isFlaming, Explosion.BlockInteraction.DESTROY, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
        this.level = level;
        this.exploder = entity;
        this.shootingEntity = player;
        this.pos = pos;
        this.explosionSize = size;
        this.playerKnockbackMap = Maps.newHashMap();
    }

    public void explode() {
        float var1 = this.explosionSize;
        this.explosionSize *= 2.0f;
        List var9 = this.level.getEntities(this.exploder, new AABB(this.pos.add((double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0, (double)(-this.explosionSize) - 1.0), this.pos.add((double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0, (double)this.explosionSize + 1.0)));
        for (Entity entity : var9) {
            if (!this.affectEntity(entity)) continue;
            this.attackEntityWithExplosion(this.pos, entity);
        }
        this.explosionSize = var1;
    }

    private void attackEntityWithExplosion(Vec3 var30, Entity entity) {
        double d9;
        double d7;
        double d5;
        double var33;
        double var13 = Math.sqrt(entity.distanceToSqr(this.pos)) / (double)this.explosionSize;
        if (var13 <= 1.0 && (var33 = Math.sqrt((d5 = entity.getX() - this.pos.x()) * d5 + (d7 = entity.getY() + (double)entity.getEyeHeight() - this.pos.y()) * d7 + (d9 = entity.getZ() - this.pos.z()) * d9)) != 0.0) {
            double var32 = ConcussiveExplosion.getSeenPercent((Vec3)var30, (Entity)entity);
            double d10 = (1.0 - var13) * var32;
            entity.hurt(entity.damageSources().thrown(this.exploder, (Entity)this.shootingEntity), (float)((int)((d10 * d10 + d10) * 6.0 * (double)(this.explosionSize * 2.0f) + 3.0)));
            entity.setDeltaMovement(entity.getDeltaMovement().add((d5 /= var33) * d10, (d7 /= var33) * d10, (d9 /= var33) * d10));
        }
    }

    protected boolean affectEntity(Entity entity) {
        return entity instanceof Mob;
    }

    public void finalizeExplosion(boolean spawnParticles) {
        this.level.playSound(null, BlockPos.containing((double)this.pos.x(), (double)this.pos.y(), (double)this.pos.z()), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(this.level.random) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f) {
            this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.pos.x(), this.pos.y(), this.pos.z(), 1.0, 0.0, 0.0);
        } else {
            this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.pos.x(), this.pos.y(), this.pos.z(), 1.0, 0.0, 0.0);
        }
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.playerKnockbackMap;
    }

    public static void customBusterExplosion(Entity par1Entity, double x, double y, double z, float par8) {
        if (par1Entity.level().isClientSide) {
            return;
        }
        par1Entity.level().explode(par1Entity, x, y, z, par8, false, Level.ExplosionInteraction.BLOCK);
    }

    public static void customConcussiveExplosion(Entity entity, Player player, Vec3 pos, float size, boolean isFlaming) {
        ConcussiveExplosion var11 = new ConcussiveExplosion(entity.level(), entity, player, pos, size, isFlaming);
        var11.explode();
        var11.finalizeExplosion(false);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SpawnConcussiveExplosionParticlesPayload(size, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    static void grenadeConcussiveExplosion(Entity entity, Player player, Vec3 pos) {
        GrenadeConcussiveExplosion var11 = new GrenadeConcussiveExplosion(entity.level(), entity, player, pos);
        var11.explode();
        var11.finalizeExplosion(false);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new SpawnConcussiveExplosionParticlesPayload(4.0f, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static class GrenadeConcussiveExplosion
    extends ConcussiveExplosion {
        GrenadeConcussiveExplosion(Level level, Entity entity, Player par3Entity, Vec3 pos) {
            super(level, entity, par3Entity, pos, 4.0f, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean affectEntity(Entity entity) {
            if (super.affectEntity(entity)) {
                if (!(entity instanceof Player)) return true;
            }
            if (!(entity instanceof Player)) return false;
            Player player = (Player)entity;
            if (this.exploder == null) return false;
            if (this.exploder.getCustomName() == null) return false;
            if (!this.exploder.getCustomName().getString().contains(player.getGameProfile().getName())) return false;
            return true;
        }
    }
}

