/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.item.AlkahestryTomeItem;

public class AlkahestryCraftingRecipe
implements CraftingRecipe {
    private final Ingredient craftingIngredient;
    private final int chargeNeeded;
    private final int resultCount;
    private ItemStack result = ItemStack.EMPTY;
    private final Ingredient tomeIngredient;

    public AlkahestryCraftingRecipe(Ingredient craftingIngredient, int chargeNeeded, int resultCount) {
        this.craftingIngredient = craftingIngredient;
        this.chargeNeeded = chargeNeeded;
        this.tomeIngredient = new TomeIngredient(chargeNeeded).toVanilla();
        this.resultCount = resultCount;
        AlkahestryRecipeRegistry.registerCraftingRecipe(this);
    }

    public boolean matches(CraftingInput inv, Level level) {
        boolean hasIngredient = false;
        boolean hasTome = false;
        for (int x = 0; x < inv.size(); ++x) {
            ItemStack slotStack = inv.getItem(x);
            if (slotStack.isEmpty()) continue;
            boolean inRecipe = false;
            if (this.craftingIngredient.test(slotStack)) {
                inRecipe = true;
                hasIngredient = true;
            } else if (!hasTome && this.tomeIngredient.test(slotStack)) {
                inRecipe = true;
                hasTome = true;
            }
            if (inRecipe) continue;
            return false;
        }
        return hasIngredient && hasTome;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.craftingIngredient, this.tomeIngredient});
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.isEmpty() || stack.getItem() == ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack craftingResult = stack.copy();
            craftingResult.setCount(this.resultCount);
            return craftingResult;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResult() {
        ItemStack[] ingredientItems;
        if (this.result.isEmpty() && (ingredientItems = this.craftingIngredient.getItems()).length > 0) {
            this.result = ingredientItems[0].copy();
            this.result.setCount(this.resultCount);
        }
        return this.result;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.getResult();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModItems.ALKAHESTRY_CRAFTING_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList remainingItems = super.getRemainingItems((RecipeInput)inv);
        this.addTomeWithUsedCharge((NonNullList<ItemStack>)remainingItems, inv);
        return remainingItems;
    }

    private void addTomeWithUsedCharge(NonNullList<ItemStack> remainingItems, CraftingInput inv) {
        for (int slot = 0; slot < remainingItems.size(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (stack.getItem() != ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack tome = stack.copy();
            ModItems.ALKAHESTRY_TOME.get().useCharge(tome, this.chargeNeeded);
            remainingItems.set(slot, (Object)tome);
            break;
        }
    }

    public boolean isSpecial() {
        return true;
    }

    public int getChargeNeeded() {
        return this.chargeNeeded;
    }

    public Ingredient getCraftingIngredient() {
        return this.craftingIngredient;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    private static class TomeIngredient
    implements ICustomIngredient {
        private final int chargeNeeded;
        private final ItemStack tomeStack;

        private TomeIngredient(int chargeNeeded) {
            this.tomeStack = AlkahestryTomeItem.setCharge(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), chargeNeeded);
            this.chargeNeeded = chargeNeeded;
        }

        public boolean test(@Nullable ItemStack stack) {
            return stack != null && stack.is((Item)ModItems.ALKAHESTRY_TOME.get()) && AlkahestryTomeItem.getCharge(stack) >= this.chargeNeeded;
        }

        public Stream<ItemStack> getItems() {
            return Stream.of(this.tomeStack);
        }

        public boolean isSimple() {
            return false;
        }

        public IngredientType<?> getType() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlkahestryCraftingRecipe> {
        private static final MapCodec<AlkahestryCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.craftingIngredient), (App)Codec.INT.fieldOf("charge").forGetter(recipe -> recipe.chargeNeeded), (App)Codec.INT.fieldOf("result_count").forGetter(recipe -> recipe.resultCount)).apply((Applicative)instance, AlkahestryCraftingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AlkahestryCraftingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AlkahestryCraftingRecipe::getCraftingIngredient, (StreamCodec)ByteBufCodecs.INT, AlkahestryCraftingRecipe::getChargeNeeded, (StreamCodec)ByteBufCodecs.INT, AlkahestryCraftingRecipe::getResultCount, AlkahestryCraftingRecipe::new);

        public MapCodec<AlkahestryCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlkahestryCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

