/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.cauldron;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import reliquary.compat.jei.cauldron.CauldronRecipeJEI;
import reliquary.init.ModItems;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionHelper;
import reliquary.util.potions.PotionMap;

public class CauldronRecipeMaker {
    private CauldronRecipeMaker() {
    }

    public static List<CauldronRecipeJEI> getRecipes() {
        ArrayList<CauldronRecipeJEI> recipes = new ArrayList<CauldronRecipeJEI>();
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            ItemStack potionEssence = new ItemStack((ItemLike)ModItems.POTION_ESSENCE.get(), 1);
            PotionHelper.addPotionContentsToStack(potionEssence, essence.getPotionContents());
            inputs.add(potionEssence);
            if (essence.getRedstoneCount() > 0) {
                inputs.add(new ItemStack((ItemLike)Items.REDSTONE, essence.getRedstoneCount()));
            }
            if (essence.getGlowstoneCount() > 0) {
                inputs.add(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, essence.getGlowstoneCount()));
            }
            ArrayList<ItemStack> splashInputs = new ArrayList<ItemStack>(inputs);
            ArrayList<ItemStack> lingeringInputs = new ArrayList<ItemStack>(inputs);
            splashInputs.add(new ItemStack((ItemLike)Items.GUNPOWDER));
            lingeringInputs.add(new ItemStack((ItemLike)Items.GUNPOWDER));
            lingeringInputs.add(new ItemStack((ItemLike)Items.DRAGON_BREATH));
            inputs.add(new ItemStack((ItemLike)Items.NETHER_WART));
            splashInputs.add(new ItemStack((ItemLike)Items.NETHER_WART));
            lingeringInputs.add(new ItemStack((ItemLike)Items.NETHER_WART));
            inputs.add(new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get(), 3));
            splashInputs.add(new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get(), 3));
            lingeringInputs.add(new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get(), 3));
            ItemStack output = new ItemStack((ItemLike)ModItems.POTION.get(), 3);
            PotionHelper.addPotionContentsToStack(output, essence.getPotionContents());
            ItemStack outputSplash = new ItemStack((ItemLike)ModItems.SPLASH_POTION.get(), 3);
            PotionHelper.addPotionContentsToStack(outputSplash, essence.getPotionContents());
            ItemStack outputLingering = new ItemStack((ItemLike)ModItems.LINGERING_POTION.get(), 3);
            PotionHelper.addPotionContentsToStack(outputLingering, essence.getPotionContents());
            recipes.add(new CauldronRecipeJEI(inputs, output));
            recipes.add(new CauldronRecipeJEI(splashInputs, outputSplash));
            recipes.add(new CauldronRecipeJEI(lingeringInputs, outputLingering));
        }
        return recipes;
    }
}

