/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import reliquary.client.gui.components.Box;
import reliquary.client.gui.components.Component;
import reliquary.client.gui.components.ItemStackPane;
import reliquary.client.gui.components.TextPane;
import reliquary.client.gui.components.XPBarPane;
import reliquary.init.ModItems;
import reliquary.reference.Colors;
import reliquary.util.InventoryHelper;
import reliquary.util.XpHelper;

public class HeroMedallionPane
extends Component {
    private final XPBarPane xpBar = new XPBarPane();
    private final TextPane levelPane = new TextPane("0", Colors.get("009900"));
    private final Box mainPane = Box.createVertical(Box.Alignment.RIGHT, this.xpBar, Box.createHorizontal(Box.Alignment.MIDDLE, new ItemStackPane(ModItems.HERO_MEDALLION.get()), this.levelPane));

    @Override
    public int getHeightInternal() {
        return this.mainPane.getHeight();
    }

    @Override
    public int getWidthInternal() {
        return this.mainPane.getWidth();
    }

    @Override
    public boolean shouldRender() {
        return !InventoryHelper.getCorrectItemFromEitherHand((Player)Minecraft.getInstance().player, ModItems.HERO_MEDALLION.get()).isEmpty();
    }

    @Override
    public void renderInternal(GuiGraphics guiGraphics, int x, int y) {
        ItemStack item = InventoryHelper.getCorrectItemFromEitherHand((Player)Minecraft.getInstance().player, ModItems.HERO_MEDALLION.get());
        if (item.isEmpty()) {
            return;
        }
        int experience = ModItems.HERO_MEDALLION.get().getExperience(item);
        int level = XpHelper.getLevelForExperience(experience);
        this.levelPane.setText(String.valueOf(level));
        int remainingExperience = experience - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        float xpRatio = (float)remainingExperience / (float)maxBarExperience;
        this.xpBar.setXpRatio(xpRatio);
        this.mainPane.render(guiGraphics, x, y);
    }
}

