/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.cookingforblockheads.client.CookingForBlockheadsClient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class FavoriteListMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<FavoriteListMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cookingforblockheads", (String)"favorite_list"));
    private final Set<ResourceLocation> favoriteItemIds;

    public FavoriteListMessage(Set<ResourceLocation> favoriteItemIds) {
        this.favoriteItemIds = favoriteItemIds;
    }

    public static void encode(FriendlyByteBuf buf, FavoriteListMessage message) {
        buf.writeVarInt(message.favoriteItemIds.size());
        for (ResourceLocation itemId : message.favoriteItemIds) {
            buf.writeResourceLocation(itemId);
        }
    }

    public static FavoriteListMessage decode(FriendlyByteBuf buf) {
        int count = buf.readVarInt();
        HashSet<ResourceLocation> favoriteItemIds = new HashSet<ResourceLocation>();
        for (int i = 0; i < count; ++i) {
            favoriteItemIds.add(buf.readResourceLocation());
        }
        return new FavoriteListMessage(favoriteItemIds);
    }

    public static void handle(Player player, FavoriteListMessage message) {
        CookingForBlockheadsClient.setFavoriteItems(message.favoriteItemIds);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

