/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.container;

import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.container.ContainerMBBase;
import com.glodblock.github.modularbees.util.ContainerResolver;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.bytes.Byte2ReferenceMap;
import it.unimi.dsi.fastutil.bytes.Byte2ReferenceOpenHashMap;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public class MBGuiHandler {
    private static final BiMap<Byte, Class<? extends ContainerResolver>> RESOLVERS = HashBiMap.create();
    private static final Byte2ReferenceMap<Supplier<? extends ContainerResolver>> RESOLVER_FACTORY = new Byte2ReferenceOpenHashMap();
    private static final IdentityHashMap<MenuType<?>, ContainerOpener> OPENERS = new IdentityHashMap();
    private static byte nextID = 0;

    public static void registerResolver(Supplier<? extends ContainerResolver> resolver) {
        ContainerResolver dummy = resolver.get();
        nextID = (byte)(nextID + 1);
        RESOLVERS.put((Object)nextID, dummy.getClass());
        RESOLVER_FACTORY.put(nextID, resolver);
    }

    public static <T, C extends ContainerMBBase<?>> MenuTypeBuilder<T, C> builder(Class<T> hostCls) {
        return new MenuTypeBuilder(hostCls);
    }

    public static void open(MenuType<?> type, Player player, ContainerResolver resolver) {
        if (player.level().isClientSide()) {
            return;
        }
        ContainerOpener opener = OPENERS.get(type);
        if (opener != null) {
            opener.open(player, resolver);
        }
    }

    public static class MenuTypeBuilder<T, C extends ContainerMBBase<?>> {
        private final Class<T> hostCls;
        private ContainerConstructor<T, C> factory;
        private ResourceLocation id;
        private MenuType<C> type;

        private MenuTypeBuilder(Class<T> hostCls) {
            this.hostCls = hostCls;
        }

        public MenuTypeBuilder<T, C> factory(ContainerConstructor<T, C> factory) {
            this.factory = factory;
            return this;
        }

        public MenuHandler build(String id) {
            return this.build(ModularBees.id(id));
        }

        public MenuHandler build(ResourceLocation id) {
            this.id = id;
            this.type = IMenuTypeExtension.create(this::fromBytes);
            OPENERS.put(this.type, this::open);
            return new MenuHandler(this.type, this.id);
        }

        private void open(Player player, ContainerResolver resolver) {
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            T host = resolver.resolve(player, this.hostCls);
            if (host == null) {
                return;
            }
            SimpleMenuProvider provider = new SimpleMenuProvider((wnd, p, pl) -> {
                C con = this.factory.construct(this.type, wnd, p, host);
                ((ContainerMBBase)((Object)((Object)con))).setResolver(resolver);
                return con;
            }, (Component)Component.empty());
            player.openMenu((MenuProvider)provider, buffer -> this.toBytes((RegistryFriendlyByteBuf)buffer, resolver));
        }

        private ContainerResolver constructResolver(RegistryFriendlyByteBuf buf) {
            Supplier factory = (Supplier)RESOLVER_FACTORY.get(buf.readByte());
            if (factory == null) {
                return null;
            }
            ContainerResolver ins = (ContainerResolver)factory.get();
            ins.fromBytes(buf);
            return ins;
        }

        private C fromBytes(int id, Inventory inv, RegistryFriendlyByteBuf buf) {
            ContainerResolver resolver = this.constructResolver(buf);
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (resolver == null) {
                if (connection != null) {
                    connection.send((Packet)new ServerboundContainerClosePacket(id));
                }
                throw new IllegalArgumentException("Unable to look up a finder in %s. Closing the GUI.".formatted(this.id));
            }
            T host = resolver.resolve(inv.player, this.hostCls);
            if (host == null) {
                if (connection != null) {
                    connection.send((Packet)new ServerboundContainerClosePacket(id));
                }
                throw new IllegalArgumentException("Unable to find host %s in %s. Closing the GUI.".formatted(this.hostCls.getCanonicalName(), this.id));
            }
            return this.factory.construct(this.type, id, inv, host);
        }

        private void toBytes(RegistryFriendlyByteBuf buf, ContainerResolver resolver) {
            buf.writeByte(((Byte)RESOLVERS.inverse().get(resolver.getClass())).byteValue());
            resolver.toBytes(buf);
        }
    }

    public static interface ContainerOpener {
        public void open(Player var1, ContainerResolver var2);
    }

    public record MenuHandler(MenuType<?> type, ResourceLocation id) {
        public void register() {
            Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)this.id, this.type);
        }

        public <T extends AbstractContainerMenu> MenuType<T> castType() {
            return this.type;
        }
    }

    public static class TileResolver
    implements ContainerResolver {
        private BlockPos pos;

        public TileResolver() {
        }

        public TileResolver(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public <T> T resolve(Player player, Class<T> type) {
            if (this.pos == null) {
                return null;
            }
            BlockEntity te = player.level().getBlockEntity(this.pos);
            if (te == null) {
                return null;
            }
            if (type.isInstance(te)) {
                return type.cast(te);
            }
            return null;
        }

        @Override
        public void fromBytes(RegistryFriendlyByteBuf buf) {
            this.pos = BlockPos.of((long)buf.readLong());
        }

        @Override
        public void toBytes(RegistryFriendlyByteBuf buf) {
            buf.writeLong(this.pos.asLong());
        }
    }

    public static interface ContainerConstructor<T, C extends ContainerMBBase<?>> {
        public C construct(MenuType<C> var1, int var2, Inventory var3, T var4);
    }
}

