/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.inventory;

import com.glodblock.github.modularbees.common.inventory.IO;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MBItemInventory
extends ItemStackHandler {
    protected final IO[] mode;
    protected final BlockEntity host;
    protected ItemFilter filter = ItemFilter.PASS;
    protected int slotLimit = 99;

    public MBItemInventory(BlockEntity host, int size) {
        super(size);
        this.host = host;
        this.mode = new IO[size];
        Arrays.fill((Object[])this.mode, (Object)IO.ALL);
    }

    public MBItemInventory(BlockEntity host, int size, ItemFilter filter) {
        super(size);
        this.host = host;
        this.filter = filter;
        this.mode = new IO[size];
        Arrays.fill((Object[])this.mode, (Object)IO.ALL);
    }

    public IO getIO(int slot) {
        return this.mode[slot];
    }

    public ItemFilter getFilter() {
        return this.filter;
    }

    public MBItemInventory setSlotLimit(int limit) {
        this.slotLimit = limit;
        return this;
    }

    public MBItemInventory setFilter(ItemFilter filter) {
        this.filter = filter;
        return this;
    }

    public MBItemInventory setIO(int slot, IO mode) {
        this.mode[slot] = mode;
        return this;
    }

    public MBItemInventory inputOnly() {
        Arrays.fill((Object[])this.mode, (Object)IO.IN);
        return this;
    }

    public MBItemInventory outputOnly() {
        Arrays.fill((Object[])this.mode, (Object)IO.OUT);
        return this;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.mode[slot].canInsert() && this.filter.valid(stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.mode[slot].canExtract()) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack forceInsertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack forceExtractItem(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    protected void onContentsChanged(int slot) {
        if (this.host != null) {
            BlockEntity blockEntity = this.host;
            if (blockEntity instanceof SlotListener) {
                SlotListener listener = (SlotListener)blockEntity;
                listener.onChange((IItemHandler)this, slot);
            }
            this.host.setChanged();
        }
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public List<ItemStack> toList() {
        return List.copyOf(this.stacks);
    }

    public int countStack(Predicate<ItemStack> filter) {
        int cnt = 0;
        for (ItemStack stack : this.stacks) {
            if (!filter.test(stack)) continue;
            ++cnt;
        }
        return cnt;
    }

    public int countStack(Item filter) {
        int cnt = 0;
        for (ItemStack stack : this.stacks) {
            if (filter != stack.getItem()) continue;
            ++cnt;
        }
        return cnt;
    }

    public static interface ItemFilter {
        public static final ItemFilter PASS = s -> true;

        public boolean valid(ItemStack var1);

        public static ItemFilter of(Item stack) {
            return input -> input.is(stack);
        }
    }
}

