/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.client.util;

import com.glodblock.github.modularbees.client.util.RelativePosition;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import org.jetbrains.annotations.NotNull;

public class ElementGroup
implements Iterable<Renderable> {
    private final Object2ReferenceMap<String, Renderable> elements = new Object2ReferenceOpenHashMap();

    public <W extends GuiEventListener & Renderable> void populate(Consumer<Renderable> renderAdder, Consumer<W> widgetAdder) {
        for (Renderable e : this.elements.values()) {
            if (e instanceof GuiEventListener && e instanceof NarratableEntry) {
                widgetAdder.accept((GuiEventListener)e);
                continue;
            }
            renderAdder.accept(e);
        }
    }

    public void reposition(int offsetX, int offsetY) {
        for (Renderable e : this.elements.values()) {
            if (!(e instanceof RelativePosition)) continue;
            RelativePosition r = (RelativePosition)e;
            r.setOffset(offsetX, offsetY);
        }
    }

    public ElementGroup add(String id, Renderable element) {
        if (this.elements.containsKey((Object)id)) {
            throw new IllegalArgumentException("ID: %s has been used".formatted(id));
        }
        this.elements.put((Object)id, (Object)element);
        return this;
    }

    public <W> W get(String id) {
        if (!this.elements.containsKey((Object)id)) {
            throw new IllegalArgumentException("ID: %s doesn't existed".formatted(id));
        }
        return (W)this.elements.get((Object)id);
    }

    @Override
    @NotNull
    public Iterator<Renderable> iterator() {
        return this.elements.values().iterator();
    }
}

