/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.client.gui;

import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.client.gui.MBBaseGui;
import com.glodblock.github.modularbees.client.gui.elements.EnergyDisplay;
import com.glodblock.github.modularbees.client.util.PicData;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveOverclocker;
import com.glodblock.github.modularbees.container.ContainerMBOverclocker;
import com.glodblock.github.modularbees.util.GameUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MBOverclockerGui
extends MBBaseGui<ContainerMBOverclocker> {
    private static final PicData BG = PicData.of(ModularBees.id("textures/gui/overclocker.png")).select(0, 0, 176, 166);

    public MBOverclockerGui(ContainerMBOverclocker container, Inventory inv, Component component) {
        super(container, inv, component);
        EnergyDisplay energy = new EnergyDisplay(container::getEnergy).capacity(((TileBeehiveOverclocker)container.getHost()).getEnergyStorage().getMaxEnergyStored()).texture(PicData.of(ModularBees.id("textures/gui/overclocker.png")).select(176, 0, 11, 52));
        energy.setPosition(43, 17);
        energy.setSize(11, 52);
        this.group.add("energy", energy);
    }

    @Override
    PicData getBackground() {
        return BG;
    }

    @Override
    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        ItemStack stack = ((TileBeehiveOverclocker)((ContainerMBOverclocker)this.getMenu()).getHost()).getItemInventory().getStackInSlot(0);
        if (stack.isEmpty()) {
            this.drawStringCenter(graphics, (Component)Component.translatable((String)"modularbees.gui.modular_beehive_overclocker.empty"), 135, 39);
        } else {
            Item item = stack.getItem();
            if (item instanceof TileBeehiveOverclocker.HiveElectrode) {
                TileBeehiveOverclocker.HiveElectrode electrode = (TileBeehiveOverclocker.HiveElectrode)item;
                this.drawStringCenter(graphics, (Component)Component.translatable((String)"modularbees.gui.modular_beehive_overclocker.boost"), 135, 33);
                this.drawStringCenter(graphics, "x" + GameUtil.NUMBER_F.format(electrode.getPower()), 132, 44);
            } else {
                this.drawStringCenter(graphics, (Component)Component.translatable((String)"modularbees.gui.modular_beehive_overclocker.empty"), 135, 39);
            }
        }
    }

    @Override
    protected Component getGuiName() {
        return MBSingletons.MODULAR_OVERCLOCKER.getName();
    }
}

