/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.client.gui;

import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.modularbees.client.util.ElementGroup;
import com.glodblock.github.modularbees.client.util.PicData;
import com.glodblock.github.modularbees.client.util.TooltipElement;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBBase;
import com.glodblock.github.modularbees.container.ContainerMBBase;
import com.glodblock.github.modularbees.network.CMBGenericPacket;
import com.glodblock.github.modularbees.network.MBNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public abstract class MBBaseGui<C extends ContainerMBBase<? extends TileMBBase>>
extends AbstractContainerScreen<C>
implements IActionHolder {
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    protected final ElementGroup group = new ElementGroup();
    private final ActionMap actions = ActionMap.create();

    public MBBaseGui(C container, Inventory inv, Component component) {
        super(container, inv, component);
    }

    abstract PicData getBackground();

    protected Component getGuiName() {
        return Component.empty();
    }

    protected void updateGuiData() {
    }

    public void sendAction(String id, Object ... paras) {
        MBNetworkHandler.INSTANCE.sendToServer((IMessage)new CMBGenericPacket(id, paras));
    }

    protected void init() {
        Rect2i select = this.getBackground().getSelect();
        this.imageHeight = select.getHeight();
        this.imageWidth = select.getWidth();
        super.init();
        this.group.reposition(this.leftPos, this.topPos);
        this.group.populate(x$0 -> this.addRenderableOnly((Renderable)x$0), x$0 -> this.addRenderableWidget((GuiEventListener)x$0));
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.updateGuiData();
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        for (Renderable e : this.group) {
            TooltipElement tooltip;
            if (!(e instanceof TooltipElement) || !(tooltip = (TooltipElement)e).shouldDisplay(mouseX, mouseY) || tooltip.getTooltipMessage(MBBaseGui.hasShiftDown()).isEmpty()) continue;
            List<Component> lines = tooltip.getTooltipMessage(MBBaseGui.hasShiftDown());
            int maxWidth = this.width / 2 - 40;
            ArrayList styledLines = new ArrayList(lines.size());
            for (Component line : lines) {
                styledLines.addAll(ComponentRenderUtils.wrapComponents((FormattedText)line, (int)maxWidth, (Font)this.font));
            }
            graphics.renderTooltip(this.font, styledLines, mouseX, mouseY);
            break;
        }
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.getBackground().render(graphics, this.leftPos, this.topPos);
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, this.getGuiName(), this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void drawStringCenter(@NotNull GuiGraphics graphics, Component text, int centerX, int y) {
        this.drawStringCenter(graphics, text, centerX, y, false);
    }

    protected void drawStringCenter(@NotNull GuiGraphics graphics, Component text, int centerX, int y, boolean shadow) {
        int length = this.font.width((FormattedText)text);
        graphics.drawString(this.font, text, centerX - length / 2, y, 0x404040, shadow);
    }

    protected void drawStringCenter(@NotNull GuiGraphics graphics, String text, int centerX, int y) {
        int length = this.font.width(text);
        graphics.drawString(this.font, text, centerX - length / 2, y, 0x404040, false);
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

