/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vsngarcia.ElevatorBlockBase;
import com.vsngarcia.level.ElevatorBlockEntityBase;
import com.vsngarcia.neoforge.client.render.ElevatorBakedModel;
import com.vsngarcia.neoforge.init.Registry;
import com.vsngarcia.neoforge.tile.ElevatorBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class ElevatorBlock
extends ElevatorBlockBase {
    private final MapCodec<ElevatorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(ElevatorBlockBase::getColor)).apply((Applicative)instance, ElevatorBlock::new));

    public ElevatorBlock(DyeColor color) {
        super(color, Registry.ELEVATOR_TILE_ENTITY::get);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return this.CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ElevatorBlockEntity(pos, state);
    }

    @Override
    protected void openMenu(Player player, ElevatorBlockEntityBase tile, BlockPos pos) {
        player.openMenu((MenuProvider)tile, pos);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return this.getHeldState(level, pos).map(s -> s.collisionExtendsVertically(level, pos, collidingEntity)).orElse(super.collisionExtendsVertically(state, level, pos, collidingEntity));
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getHeldState((BlockGetter)level, pos).map(s -> Float.valueOf(s.getFriction(level, pos, entity))).orElse(Float.valueOf(super.getFriction(state, level, pos, entity))).floatValue();
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        if (level instanceof ServerLevel) {
            return this.getHeldState((BlockGetter)level, pos).map(s -> s.getAppearance(level, pos, side, queryState, queryPos)).orElse(super.getAppearance(state, level, pos, side, queryState, queryPos));
        }
        ModelData data = level.getModelData(pos);
        if (data == ModelData.EMPTY) {
            return super.getAppearance(state, level, pos, side, queryState, queryPos);
        }
        BlockState heldState = (BlockState)data.get(ElevatorBakedModel.HELD_STATE);
        if (heldState == null) {
            return super.getAppearance(state, level, pos, side, queryState, queryPos);
        }
        return heldState.getAppearance(level, pos, side, queryState, queryPos);
    }

    @Override
    protected BlockState getAppearance(BlockState facingState, LevelAccessor worldIn, BlockPos facingPos, Direction opposite, BlockState heldState, BlockPos currentPos) {
        return facingState.getAppearance((BlockAndTintGetter)worldIn, facingPos, opposite, heldState, currentPos);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        ModelData modelData = level.getModelData(pos);
        if (modelData == ModelData.EMPTY) {
            return super.hidesNeighborFace(level, pos, state, neighborState, dir);
        }
        BlockState heldState = (BlockState)modelData.get(ElevatorBakedModel.HELD_STATE);
        if (heldState == null) {
            return super.hidesNeighborFace(level, pos, state, neighborState, dir);
        }
        ModelData neighborModelData = level.getModelData(pos.relative(dir));
        if (neighborModelData == ModelData.EMPTY) {
            return heldState.skipRendering(neighborState, dir);
        }
        BlockState neighborHeldState = (BlockState)neighborModelData.get(ElevatorBakedModel.HELD_STATE);
        return heldState.skipRendering(neighborHeldState != null ? neighborHeldState : neighborState, dir);
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.getAuxLightManager(pos)).map(lm -> lm.getLightAt(pos)).orElse(0);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.getHeldState(level, pos).map(s -> s.getBlock().canConnectRedstone(s, level, pos, direction)).orElse(super.canConnectRedstone(state, level, pos, direction));
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return this.getHeldState((BlockGetter)level, pos).map(s -> s.shouldCheckWeakPower(level, pos, side)).orElse(super.shouldCheckWeakPower(state, level, pos, side));
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getHeldState((BlockGetter)level, pos).map(s -> s.getSoundType(level, pos, entity)).orElse(super.getSoundType(state, level, pos, entity));
    }
}

