/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TextUtil;

public class RepairKitItem
extends Item {
    private final Supplier<Integer> capacity;
    private final Supplier<Double> efficiency;

    public RepairKitItem(Supplier<Integer> capacity, Supplier<Double> efficiency, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.efficiency = efficiency;
    }

    public boolean addMaterial(ItemStack repairKit, ItemStack materialStack) {
        MaterialInstance material = MaterialInstance.from(materialStack);
        if (material == null) {
            return false;
        }
        float materialValue = this.getMaterialValue(material);
        if (RepairKitItem.getTotalStoredMaterialAmount(repairKit) > (float)this.getKitCapacity() - materialValue) {
            return false;
        }
        HashMap<MaterialInstance, Float> materialStorage = new HashMap<MaterialInstance, Float>((Map)repairKit.getOrDefault(SgDataComponents.MATERIAL_STORAGE, Collections.emptyMap()));
        materialStorage.merge(material, Float.valueOf(materialValue), Float::sum);
        repairKit.set(SgDataComponents.MATERIAL_STORAGE, (Object)ImmutableMap.copyOf(materialStorage));
        return true;
    }

    private float getMaterialValue(MaterialInstance material) {
        return 1.0f;
    }

    private int getKitCapacity() {
        return this.capacity.get();
    }

    public float getRepairEfficiency(RepairContext.Type repairType) {
        return this.efficiency.get().floatValue() + repairType.getBonusEfficiency();
    }

    private static float getStoredAmount(ItemStack stack, MaterialInstance material) {
        Map materialStorage = (Map)stack.get(SgDataComponents.MATERIAL_STORAGE);
        return materialStorage != null ? materialStorage.getOrDefault(material, Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    private static float getTotalStoredMaterialAmount(ItemStack repairKit) {
        float sum = 0.0f;
        for (float amount : RepairKitItem.getStoredMaterials(repairKit).values()) {
            sum += amount;
        }
        return sum;
    }

    private static Map<MaterialInstance, Float> getStoredMaterials(ItemStack stack) {
        return new HashMap<MaterialInstance, Float>((Map)stack.getOrDefault(SgDataComponents.MATERIAL_STORAGE, Collections.emptyMap()));
    }

    private Pair<Map<MaterialInstance, Float>, Integer> getMaterialsToRepair(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        Map<MaterialInstance, Float> stored = RepairKitItem.getStoredMaterials(repairKit);
        HashMap<MaterialInstance, Float> used = new HashMap<MaterialInstance, Float>();
        float gearRepairEfficiency = GearData.getProperties(gear).getNumber(GearProperties.REPAIR_EFFICIENCY);
        float kitEfficiency = this.getRepairEfficiency(repairType);
        int damageLeft = gear.getDamageValue();
        if (gearRepairEfficiency > 0.0f && kitEfficiency > 0.0f) {
            for (Map.Entry<MaterialInstance, Float> entry : stored.entrySet()) {
                MaterialInstance mat = entry.getKey();
                float amount = entry.getValue().floatValue();
                int repairValue = mat.getRepairValue(gear);
                if (repairValue <= 0) continue;
                float totalRepairValue = (float)repairValue * amount;
                int maxRepair = Math.round(totalRepairValue * gearRepairEfficiency * kitEfficiency);
                int toRepair = Math.min(maxRepair, damageLeft);
                float repairValueUsed = (float)toRepair / gearRepairEfficiency / kitEfficiency;
                float amountUsed = repairValueUsed / (float)repairValue;
                used.put(mat, Float.valueOf(amountUsed));
                if ((damageLeft -= toRepair) > 0) continue;
                break;
            }
        }
        return Pair.of(used, (Object)(gear.getDamageValue() - damageLeft));
    }

    public Map<MaterialInstance, Float> getRepairMaterials(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        return (Map)this.getMaterialsToRepair(gear, repairKit, repairType).getFirst();
    }

    public int getDamageToRepair(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        return (Integer)this.getMaterialsToRepair(gear, repairKit, repairType).getSecond();
    }

    public void removeRepairMaterials(ItemStack repairKit, Map<MaterialInstance, Float> toRemove) {
        Map<MaterialInstance, Float> storedMaterials = RepairKitItem.getStoredMaterials(repairKit);
        toRemove.forEach((material, value) -> {
            if (storedMaterials.containsKey(material)) {
                float newValue = ((Float)storedMaterials.get(material)).floatValue() - value.floatValue();
                if (newValue < 0.01f) {
                    storedMaterials.remove(material);
                } else {
                    storedMaterials.put((MaterialInstance)material, Float.valueOf(newValue));
                }
            }
        });
        repairKit.set(SgDataComponents.MATERIAL_STORAGE, storedMaterials);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)TextUtil.translate("item", "repair_kit.efficiency", (int)(this.getRepairEfficiency(RepairContext.Type.QUICK) * 100.0f)));
        tooltip.add((Component)TextUtil.translate("item", "repair_kit.capacity", RepairKitItem.format(RepairKitItem.getTotalStoredMaterialAmount(stack)), this.getKitCapacity()));
        Map<MaterialInstance, Float> storedMaterials = RepairKitItem.getStoredMaterials(stack);
        if (storedMaterials.isEmpty()) {
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.hint1").withStyle(ChatFormatting.ITALIC));
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.hint2").withStyle(ChatFormatting.ITALIC));
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.hint3").withStyle(ChatFormatting.ITALIC));
            return;
        }
        for (Map.Entry<MaterialInstance, Float> entry : storedMaterials.entrySet()) {
            tooltip.add((Component)TextUtil.translate("item", "repair_kit.material", entry.getKey().getDisplayNameWithModifiers((PartType)PartTypes.MAIN.get(), ItemStack.EMPTY), RepairKitItem.format(entry.getValue().floatValue())));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * RepairKitItem.getTotalStoredMaterialAmount(stack) / (float)this.getKitCapacity());
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (13.0f - (float)this.getBarWidth(stack)) / 13.0f) / 3.0f + 0.5f), (float)1.0f, (float)1.0f);
    }

    private static String format(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }
}

