/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.CodecUtils;

public class BlockMiningSpeedTraitEffect
extends TraitEffect {
    public static final MapCodec<BlockMiningSpeedTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("block_tag").forGetter(e -> e.blocks), (App)Codec.FLOAT.fieldOf("speed_modifier").forGetter(e -> Float.valueOf(e.speedModifier))).apply((Applicative)instance, BlockMiningSpeedTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockMiningSpeedTraitEffect> STREAM_CODEC = StreamCodec.composite(CodecUtils.tagStreamCodec(Registries.BLOCK), e -> e.blocks, (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.speedModifier), BlockMiningSpeedTraitEffect::new);
    private final TagKey<Block> blocks;
    private final float speedModifier;

    public BlockMiningSpeedTraitEffect(TagKey<Block> blocks, float speedModifier) {
        this.blocks = blocks;
        this.speedModifier = speedModifier;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.BLOCK_MINING_SPEED.get();
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        return List.of();
    }

    @Override
    public float getMiningSpeedModifier(int traitLevel, BlockState state) {
        if (state.is(this.blocks)) {
            return (float)traitLevel * this.speedModifier;
        }
        return 0.0f;
    }
}

