/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.silentchaos512.gear.block.ModCropBlock;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.lib.util.NameUtils;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "silentgear", exFileHelper);
    }

    @Nonnull
    public String getName() {
        return "Silent Gear - Block States/Models";
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)SgBlocks.BORT_ORE.get());
        this.simpleBlock((Block)SgBlocks.DEEPSLATE_BORT_ORE.get());
        this.simpleBlock((Block)SgBlocks.CRIMSON_IRON_ORE.get());
        this.simpleBlock((Block)SgBlocks.BLACKSTONE_CRIMSON_IRON_ORE.get());
        this.simpleBlock((Block)SgBlocks.AZURE_SILVER_ORE.get());
        this.simpleBlock((Block)SgBlocks.RAW_CRIMSON_IRON_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.RAW_AZURE_SILVER_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.BORT_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.CRIMSON_IRON_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.CRIMSON_STEEL_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.BLAZE_GOLD_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.AZURE_SILVER_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.AZURE_ELECTRUM_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.TYRIAN_STEEL_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.NETHERWOOD_CHARCOAL_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.NETHERWOOD_PLANKS.get());
        this.simpleBlock((Block)SgBlocks.NETHERWOOD_LEAVES.get());
        this.axisBlock((RotatedPillarBlock)SgBlocks.NETHERWOOD_LOG.get(), this.modLoc("block/netherwood_log"), this.modLoc("block/netherwood_log_top"));
        this.axisBlock((RotatedPillarBlock)SgBlocks.STRIPPED_NETHERWOOD_LOG.get(), this.modLoc("block/stripped_netherwood_log"), this.modLoc("block/stripped_netherwood_log_top"));
        this.simpleBlock((Block)SgBlocks.NETHERWOOD_WOOD.get(), (ModelFile)this.models().cubeAll("netherwood_wood", this.modLoc("block/netherwood_log")));
        this.simpleBlock((Block)SgBlocks.STRIPPED_NETHERWOOD_WOOD.get(), (ModelFile)this.models().cubeAll("stripped_netherwood_wood", this.modLoc("block/stripped_netherwood_log")));
        this.simpleBlock((Block)SgBlocks.NETHERWOOD_SAPLING.get(), (ModelFile)((BlockModelBuilder)this.models().cross("netherwood_sapling", this.modLoc("block/netherwood_sapling"))).renderType("cutout"));
        ResourceLocation planks = this.modLoc("block/netherwood_planks");
        this.slabBlock((SlabBlock)SgBlocks.NETHERWOOD_SLAB.get(), planks, planks);
        this.stairsBlock((StairBlock)SgBlocks.NETHERWOOD_STAIRS.get(), planks);
        this.fenceBlock((FenceBlock)SgBlocks.NETHERWOOD_FENCE.get(), planks);
        this.fenceGateBlock((FenceGateBlock)SgBlocks.NETHERWOOD_FENCE_GATE.get(), planks);
        this.doorBlockInternal((DoorBlock)SgBlocks.NETHERWOOD_DOOR.get(), this.modLoc("block/netherwood_door_bottom"), this.modLoc("block/netherwood_door_top"));
        this.trapdoorBlockInternal((TrapDoorBlock)SgBlocks.NETHERWOOD_TRAPDOOR.get(), this.modLoc("block/netherwood_trapdoor"), true);
        this.simpleBlock((Block)SgBlocks.WHITE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.ORANGE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.MAGENTA_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.YELLOW_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.LIME_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.PINK_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.GRAY_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.CYAN_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.PURPLE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.BLUE_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.BROWN_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.GREEN_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.RED_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.BLACK_FLUFFY_BLOCK.get());
        this.simpleBlock((Block)SgBlocks.PHANTOM_LIGHT.get(), (ModelFile)this.models().cubeAll("phantom_light", this.modLoc("item/blank")));
        this.simpleBlock((Block)SgBlocks.POTTED_NETHERWOOD_SAPLING.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("potted_netherwood_sapling", "block/flower_pot_cross")).texture("plant", "block/netherwood_sapling"));
        this.simpleBlock((Block)SgBlocks.STONE_TORCH.get(), (ModelFile)((BlockModelBuilder)this.models().torch("stone_torch", this.modLoc("block/stone_torch"))).renderType("cutout"));
        this.getVariantBuilder((Block)SgBlocks.WALL_STONE_TORCH.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.wallTorch("wall_stone_torch", this.modLoc("block/stone_torch"))).rotationY((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90).build());
        this.simpleBlock((Block)SgBlocks.GEAR_SMITHING_TABLE.get(), (ModelFile)this.getExistingModel("gear_smithing_table"));
        this.simpleBlock((Block)SgBlocks.STARLIGHT_CHARGER.get(), (ModelFile)this.getExistingModel("starlight_charger"));
        this.simpleBlock((Block)SgBlocks.STONE_ANVIL.get(), (ModelFile)this.getExistingModel("stone_anvil"));
        this.orientableMachineBlock(SgBlocks.MATERIAL_GRADER, "material_grader");
        this.orientableMachineBlock(SgBlocks.METAL_PRESS, "metal_press");
        this.orientableMachineBlock(SgBlocks.SALVAGER, "salvager");
        this.orientableMachineBlock(SgBlocks.ALLOY_FORGE, "alloy_forge");
        this.orientableMachineBlock(SgBlocks.RECRYSTALLIZER, "recrystallizer");
        this.orientableMachineBlock(SgBlocks.REFABRICATOR, "refabricator");
        this.simpleBlock((Block)SgBlocks.SUPER_MIXER.get());
        this.getVariantBuilder((Block)SgBlocks.FLAX_PLANT.get()).forAllStates(state -> {
            int i = ModBlockStateProvider.cropAgeToIndex((Integer)state.getValue((Property)ModCropBlock.AGE));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().crop("flax_plant" + i, this.modLoc("block/flax_plant" + i))).renderType("cutout")).build();
        });
        this.simpleBlock((Block)SgBlocks.WILD_FLAX_PLANT.get(), (ModelFile)((BlockModelBuilder)this.models().crop("wild_flax_plant", this.modLoc("block/flax_plant3"))).renderType("cutout"));
        this.getVariantBuilder((Block)SgBlocks.FLUFFY_PLANT.get()).forAllStates(state -> {
            int i = ModBlockStateProvider.cropAgeToIndex((Integer)state.getValue((Property)ModCropBlock.AGE));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().crop("fluffy_plant" + i, this.modLoc("block/fluffy_plant" + i))).renderType("cutout")).build();
        });
        this.simpleBlock((Block)SgBlocks.WILD_FLUFFY_PLANT.get(), (ModelFile)((BlockModelBuilder)this.models().crop("wild_fluffy_plant", this.modLoc("block/fluffy_plant3"))).renderType("cutout"));
    }

    private ModelFile.ExistingModelFile getExistingModel(String blockName) {
        return this.models().getExistingFile(this.modLoc(blockName));
    }

    private void orientableMachineBlock(DeferredBlock<? extends Block> block, String name) {
        ModelFile.ExistingModelFile offModel = this.getExistingModel(name);
        ModelFile.ExistingModelFile onModel = this.getExistingModel(name + "_on");
        this.getVariantBuilder((Block)block.value()).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            boolean lit = (Boolean)state.getValue((Property)BlockStateProperties.LIT);
            return ConfiguredModel.builder().modelFile((ModelFile)(lit ? onModel : offModel)).rotationY((int)facing.getOpposite().toYRot()).build();
        });
    }

    public ModelBuilder<BlockModelBuilder> wallTorch(String name, ResourceLocation torch) {
        return ((BlockModelBuilder)this.models().singleTexture(name, this.mcLoc("block/wall_torch"), "torch", torch)).renderType("cutout");
    }

    private static int cropAgeToIndex(int age) {
        if (age > 6) {
            return 3;
        }
        if (age > 3) {
            return 2;
        }
        if (age > 1) {
            return 1;
        }
        return 0;
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        super.fenceBlock(block, texture);
        ((BlockModelBuilder)this.models().withExistingParent(NameUtils.fromBlock((Block)block).getPath() + "_inventory", this.mcLoc("block/fence_inventory"))).texture("texture", texture);
    }

    private void doorBlockInternal(DoorBlock block, ResourceLocation bottom, ResourceLocation top) {
        String baseName = NameUtils.fromBlock((Block)block).toString();
        ModelBuilder bottomLeft = ((BlockModelBuilder)this.models().doorBottomLeft(baseName + "_bottom_left", bottom, top)).renderType("cutout");
        ModelBuilder bottomLeftOpen = ((BlockModelBuilder)this.models().doorBottomLeftOpen(baseName + "_bottom_left_open", bottom, top)).renderType("cutout");
        ModelBuilder bottomRight = ((BlockModelBuilder)this.models().doorBottomRight(baseName + "_bottom_right", bottom, top)).renderType("cutout");
        ModelBuilder bottomRightOpen = ((BlockModelBuilder)this.models().doorBottomRightOpen(baseName + "_bottom_right_open", bottom, top)).renderType("cutout");
        ModelBuilder topLeft = ((BlockModelBuilder)this.models().doorTopLeft(baseName + "_top_left", bottom, top)).renderType("cutout");
        ModelBuilder topLeftOpen = ((BlockModelBuilder)this.models().doorTopLeftOpen(baseName + "_top_left_open", bottom, top)).renderType("cutout");
        ModelBuilder topRight = ((BlockModelBuilder)this.models().doorTopRight(baseName + "_top_right", bottom, top)).renderType("cutout");
        ModelBuilder topRightOpen = ((BlockModelBuilder)this.models().doorTopRightOpen(baseName + "_top_right_open", bottom, top)).renderType("cutout");
        this.doorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    private void trapdoorBlockInternal(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        String baseName = NameUtils.fromBlock((Block)block).toString();
        ModelBuilder bottom = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableBottom(baseName + "_bottom", texture)).renderType("cutout") : ((BlockModelBuilder)this.models().trapdoorBottom(baseName + "_bottom", texture)).renderType("cutout");
        ModelBuilder top = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableTop(baseName + "_top", texture)).renderType("cutout") : ((BlockModelBuilder)this.models().trapdoorTop(baseName + "_top", texture)).renderType("cutout");
        ModelBuilder open = orientable ? ((BlockModelBuilder)this.models().trapdoorOrientableOpen(baseName + "_open", texture)).renderType("cutout") : ((BlockModelBuilder)this.models().trapdoorOpen(baseName + "_open", texture)).renderType("cutout");
        this.trapdoorBlock(block, (ModelFile)bottom, (ModelFile)top, (ModelFile)open, orientable);
    }
}

