/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.model.GearTridentModel;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.setup.gear.PartTypes;

public class SgBlockEntityWithoutLevelRenderer
extends BlockEntityWithoutLevelRenderer {
    private GearTridentModel trident_model = GearTridentModel.bakeModel();

    public SgBlockEntityWithoutLevelRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transform, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        if (transform == ItemDisplayContext.GUI || transform == ItemDisplayContext.FIXED || transform == ItemDisplayContext.GROUND) {
            BakedModel model = modelManager.getModel(GearTridentModel.TRIDENT_ICON);
            model = model.getOverrides().resolve(model, stack, null, null, 0);
            itemRenderer.render(stack, transform, false, poseStack, bufferSource, packedLight, packedOverlay, model);
        } else {
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            VertexConsumer vertexconsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)this.trident_model.renderType(GearTridentModel.TEXTURE), (boolean)false, (boolean)false);
            int color_toolrod = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.ROD.get());
            int color_grip = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.GRIP.get());
            int color_spikes = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.MAIN.get());
            int color_tip = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.TIP.get());
            int color_coating = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.COATING.get());
            color_spikes = color_coating == -1 ? color_spikes : color_coating;
            color_grip = color_grip == -1 ? color_toolrod : color_grip;
            color_tip = color_tip == -1 ? color_spikes : color_tip;
            this.trident_model.renderWithColors(poseStack, vertexconsumer, packedLight, packedOverlay, color_toolrod, color_grip, color_spikes, color_tip);
            poseStack.popPose();
        }
    }
}

