/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.block.charger.ChargerBlockEntity;
import net.silentchaos512.gear.setup.SgMenuTypes;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.lib.inventory.SlotOutputOnly;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.MathUtils;

public class ChargerContainerMenu
extends AbstractContainerMenu {
    final Container inventory;
    final ContainerData fields;

    public ChargerContainerMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf data) {
        this(type, id, inv, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData((int)data.readByte()));
    }

    public ChargerContainerMenu(MenuType<?> type, int id, Inventory inv, Container blockInv, ContainerData fields) {
        super(type, id);
        this.inventory = blockInv;
        this.fields = fields;
        ChargerContainerMenu.checkContainerSize((Container)this.inventory, (int)3);
        this.addSlot(new Slot(this, this.inventory, 0, 56, 23){

            public boolean mayPlace(ItemStack stack) {
                return ChargerBlockEntity.canCharge(stack);
            }
        });
        this.addSlot(new Slot(this, this.inventory, 1, 56, 46){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(SgTags.Items.STARLIGHT_CHARGER_CATALYSTS);
            }
        });
        this.addSlot((Slot)new SlotOutputOnly(this.inventory, 2, 116, 35));
        InventoryUtils.createPlayerSlots((Inventory)inv, (int)8, (int)84).forEach(x$0 -> this.addSlot((Slot)x$0));
        this.addDataSlots(this.fields);
    }

    public static ChargerContainerMenu createStarlightCharger(int id, Inventory inv, FriendlyByteBuf data) {
        return new ChargerContainerMenu((MenuType)SgMenuTypes.STARLIGHT_CHARGER.get(), id, inv, data);
    }

    public static ChargerContainerMenu createStarlightCharger(int id, Inventory inv, Container blockInv, ContainerData fields) {
        return new ChargerContainerMenu((MenuType)SgMenuTypes.STARLIGHT_CHARGER.get(), id, inv, blockInv, fields);
    }

    public int getWorkProgress() {
        return this.fields.get(0);
    }

    public int getWorkTime() {
        return this.fields.get(1);
    }

    public int getStructureLevel() {
        return this.fields.get(2);
    }

    public int getCharge() {
        int upper = this.fields.get(4) & 0xFFFF;
        int lower = this.fields.get(3) & 0xFFFF;
        return (upper << 16) + lower;
    }

    public int getMaxCharge() {
        int upper = this.fields.get(6) & 0xFFFF;
        int lower = this.fields.get(5) & 0xFFFF;
        return (upper << 16) + lower;
    }

    public int getChargeMeterHeight() {
        int max = this.getMaxCharge();
        int clamped = MathUtils.clamp((int)this.getCharge(), (int)0, (int)max);
        return max > 0 ? 50 * clamped / max : 0;
    }

    public int getProgressArrowScale() {
        int progress = this.getWorkProgress();
        int workTime = this.getWorkTime();
        return progress != 0 && workTime > 0 ? progress * 24 / workTime : 0;
    }

    public boolean stillValid(Player playerIn) {
        return this.inventory.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            int size;
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            int startPlayer = size = this.inventory.getContainerSize();
            int endPlayer = size + 27;
            int startHotbar = size + 27;
            int endHotbar = size + 36;
            if (index == 2 ? !this.moveItemStackTo(stack1, startPlayer, endHotbar, true) : (index >= size && this.inventory.canPlaceItem(0, stack1) ? !this.moveItemStackTo(stack1, 0, 1, false) : (index >= size && this.inventory.canPlaceItem(1, stack1) ? !this.moveItemStackTo(stack1, 1, 2, false) : (index >= startPlayer && index < endPlayer ? !this.moveItemStackTo(stack1, startHotbar, endHotbar, false) : (index >= startHotbar && index < endHotbar ? !this.moveItemStackTo(stack1, startPlayer, endPlayer, false) : !this.moveItemStackTo(stack1, startPlayer, endHotbar, false)))))) {
                return ItemStack.EMPTY;
            }
            if (stack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack1.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stack1);
        }
        return stack;
    }
}

