/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.alloymaker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.IDroppableInventory;
import net.silentchaos512.gear.block.SgContainerBlockEntity;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerContainer;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerInfo;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipeInput;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.lib.util.TimeUtils;
import org.apache.commons.lang3.NotImplementedException;

public class AlloyMakerBlockEntity<R extends AlloyRecipe>
extends SgContainerBlockEntity
implements IDroppableInventory {
    public static final int STANDARD_INPUT_SLOTS = 4;
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private final AlloyMakerInfo<R> info;
    private final RecipeManager.CachedCheck<AlloyRecipeInput, R> quickCheck;
    private ItemStack outputItemHint = ItemStack.EMPTY;
    private int progress = 0;
    private boolean workEnabled = true;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> AlloyMakerBlockEntity.this.progress;
                case 1 -> {
                    if (AlloyMakerBlockEntity.this.workEnabled) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    AlloyMakerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AlloyMakerBlockEntity.this.workEnabled = value != 0;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public AlloyMakerBlockEntity(AlloyMakerInfo<R> info, BlockPos pos, BlockState state) {
        super(info.getBlockEntityType(), pos, state, () -> AlloyMakerBlockEntity.createItemHandler(info));
        this.info = info;
        this.quickCheck = RecipeManager.createCheck(info.getRecipeType());
    }

    protected RecipeType<R> getRecipeType() {
        return this.info.getRecipeType();
    }

    protected CompoundMaterialItem getOutputItem(List<MaterialInstance> materials) {
        return this.info.getOutputItem();
    }

    protected ItemStack getWorkOutput(@Nullable R recipe, RegistryAccess registryAccess, List<MaterialInstance> materials) {
        if (recipe != null) {
            return ((AlloyRecipe)recipe).assemble(AlloyRecipeInput.of(this), (HolderLookup.Provider)registryAccess);
        }
        return this.getOutputItem(materials).create(materials);
    }

    public int getInputSlotCount() {
        return this.getContainerSize() - 2;
    }

    public int getOutputSlotIndex() {
        return this.getContainerSize() - 2;
    }

    public int getOutputHintSlotIndex() {
        return this.getContainerSize() - 1;
    }

    public ItemStack getHintStack() {
        return this.getItem(this.getOutputHintSlotIndex());
    }

    public void encodeExtraData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.getItemHandler().getSlots());
        buffer.writeByte(this.fields.getCount());
    }

    private boolean areInputsEmpty() {
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static <R extends AlloyRecipe> void tick(Level level, BlockPos pos, BlockState state, AlloyMakerBlockEntity<R> blockEntity) {
        if (blockEntity.areInputsEmpty()) {
            blockEntity.updateOutputHint(ItemStack.EMPTY);
            return;
        }
        RecipeHolder recipe = blockEntity.quickCheck.getRecipeFor((RecipeInput)AlloyRecipeInput.of(blockEntity), level).orElse(null);
        if (recipe != null) {
            blockEntity.doWork((AlloyRecipe)recipe.value(), level.registryAccess(), Collections.emptyList());
        } else {
            List<MaterialInstance> materials = blockEntity.getInputs();
            if (!AlloyMakerBlockEntity.hasMultipleMaterials(materials) || !blockEntity.canCompoundMaterials(materials)) {
                blockEntity.stopWork(true);
                return;
            }
            blockEntity.doWork(null, level.registryAccess(), materials);
        }
    }

    private void doWork(@Nullable R recipe, RegistryAccess registryAccess, List<MaterialInstance> materials) {
        assert (this.level != null);
        ItemStack current = this.getItem(this.getOutputSlotIndex());
        ItemStack output = this.getWorkOutput(recipe, registryAccess, materials);
        this.updateOutputHint(output);
        if (!current.isEmpty()) {
            int newCount = current.getCount() + output.getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)output) || newCount > output.getMaxStackSize()) {
                this.stopWork(false);
                return;
            }
        }
        if (this.workEnabled) {
            if (this.progress < WORK_TIME) {
                ++this.progress;
            }
            if (this.progress >= WORK_TIME && !this.level.isClientSide) {
                this.finishWork(recipe, registryAccess, materials, current);
            }
        } else {
            this.stopWork(false);
        }
    }

    private void updateOutputHint(ItemStack hintStack) {
        this.setItem(this.getOutputHintSlotIndex(), hintStack);
    }

    private void stopWork(boolean clearHintItem) {
        this.progress = 0;
        if (clearHintItem) {
            this.setItem(this.getOutputHintSlotIndex(), ItemStack.EMPTY);
        }
    }

    private void finishWork(@Nullable R recipe, RegistryAccess registryAccess, List<MaterialInstance> materials, ItemStack current) {
        this.progress = 0;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            this.removeItem(i, 1);
        }
        ItemStack output = this.getWorkOutput(recipe, registryAccess, materials);
        if (!current.isEmpty()) {
            current.grow(output.getCount());
        } else {
            this.setItem(this.getOutputSlotIndex(), output);
        }
    }

    private static boolean hasMultipleMaterials(List<MaterialInstance> materials) {
        if (materials.size() < 2) {
            return false;
        }
        Material first = materials.get(0).get();
        for (int i = 1; i < materials.size(); ++i) {
            if (materials.get(i).get() == first) continue;
            return true;
        }
        return false;
    }

    private boolean canCompoundMaterials(Iterable<MaterialInstance> materials) {
        HashSet partTypes = new HashSet(SgRegistries.PART_TYPE.stream().toList());
        for (MaterialInstance material : materials) {
            if (!this.info.acceptsMaterial(material)) {
                return false;
            }
            partTypes.removeIf(pt -> !material.getPartTypes().contains(pt));
        }
        partTypes.removeIf(partType -> {
            for (MaterialInstance material : materials) {
                if (((Boolean)material.getProperty((PartType)partType, GearProperties.ADDITIVE.get())).booleanValue()) continue;
                return false;
            }
            return true;
        });
        return !partTypes.isEmpty();
    }

    private List<MaterialInstance> getInputs() {
        boolean allEmpty = true;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return Collections.emptyList();
        }
        ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            MaterialInstance material = MaterialInstance.from(stack);
            if (material != null && material.get().isSimple()) {
                ret.add(material);
                continue;
            }
            return Collections.emptyList();
        }
        return ret;
    }

    @Override
    public NonNullList<ItemStack> getItemsToDrop() {
        NonNullList ret = NonNullList.create();
        for (int i = 0; i < this.getContainerSize() - 1; ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            ret.add((Object)stack);
        }
        return ret;
    }

    public void setChanged() {
        this.progress = 0;
        super.setChanged();
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        return index < this.getInputSlotCount();
    }

    protected Component getDefaultName() {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey(this.info.getBlock());
        return Component.translatable((String)Util.makeDescriptionId((String)"container", (ResourceLocation)key));
    }

    @Override
    public ItemStackHandler createItemHandler() {
        throw new NotImplementedException("Please use the secondary SgContainerBlockEntity constructor for AlloyMakerBlockEntity");
    }

    public static ItemStackHandler createItemHandler(final AlloyMakerInfo<?> info) {
        final int inputSlotCount = info.getInputSlotCount();
        int totalSlots = inputSlotCount + 2;
        return new ItemStackHandler(totalSlots){

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot >= 0 && slot < inputSlotCount) {
                    MaterialInstance material = MaterialInstance.from(stack);
                    return material != null && info.acceptsMaterial(material);
                }
                return false;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != inputSlotCount) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new AlloyMakerContainer(this.info.getContainerType(), id, player, (Container)this, this.fields, this.info.getCategories());
    }

    @Override
    public void loadAdditional(CompoundTag tags, HolderLookup.Provider provider) {
        super.loadAdditional(tags, provider);
        this.progress = tags.getInt("Progress");
        this.workEnabled = tags.getBoolean("WorkEnabled");
    }

    @Override
    public void saveAdditional(CompoundTag tags, HolderLookup.Provider provider) {
        super.saveAdditional(tags, provider);
        tags.putInt("Progress", this.progress);
        tags.putBoolean("WorkEnabled", this.workEnabled);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tags = super.getUpdateTag(provider);
        tags.putInt("Progress", this.progress);
        tags.putBoolean("WorkEnabled", this.workEnabled);
        return tags;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        super.onDataPacket(net, packet, provider);
        CompoundTag tags = packet.getTag();
        if (tags != null) {
            this.progress = tags.getInt("Progress");
            this.workEnabled = tags.getBoolean("WorkEnabled");
        }
    }
}

