/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.search.AutomatonQuery;
import org.apache.lucene.ars_nouveau.search.MultiTermQuery;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.automaton.Automaton;

public class PrefixQuery
extends AutomatonQuery {
    public PrefixQuery(Term prefix) {
        this(prefix, CONSTANT_SCORE_BLENDED_REWRITE);
    }

    public PrefixQuery(Term prefix, MultiTermQuery.RewriteMethod rewriteMethod) {
        super(prefix, PrefixQuery.toAutomaton(prefix.bytes()), true, rewriteMethod);
    }

    public static Automaton toAutomaton(BytesRef prefix) {
        int numStatesAndTransitions = prefix.length + 1;
        Automaton automaton = new Automaton(numStatesAndTransitions, numStatesAndTransitions);
        int lastState = automaton.createState();
        for (int i = 0; i < prefix.length; ++i) {
            int state = automaton.createState();
            automaton.addTransition(lastState, state, prefix.bytes[prefix.offset + i] & 0xFF);
            lastState = state;
        }
        automaton.setAccept(lastState, true);
        automaton.addTransition(lastState, lastState, 0, 255);
        automaton.finishState();
        assert (automaton.isDeterministic());
        return automaton;
    }

    public Term getPrefix() {
        return this.term;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(':');
        }
        buffer.append(this.term.text());
        buffer.append('*');
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.term.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PrefixQuery other = (PrefixQuery)obj;
        return this.term.equals(other.term);
    }
}

