/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.taxonomy;

import java.util.Arrays;
import org.apache.lucene.ars_nouveau.document.Field;
import org.apache.lucene.ars_nouveau.document.FieldType;
import org.apache.lucene.ars_nouveau.facet.FacetField;
import org.apache.lucene.ars_nouveau.index.IndexOptions;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class AssociationFacetField
extends Field {
    public static final FieldType TYPE = new FieldType();
    public final String dim;
    public final String[] path;
    public final BytesRef assoc;

    public AssociationFacetField(BytesRef assoc, String dim, String ... path) {
        super("dummy", TYPE);
        FacetField.verifyLabel(dim);
        for (String label : path) {
            FacetField.verifyLabel(label);
        }
        this.dim = dim;
        this.assoc = assoc;
        if (path.length == 0) {
            throw new IllegalArgumentException("path must have at least one element");
        }
        this.path = path;
    }

    @Override
    public String toString() {
        return "AssociationFacetField(dim=" + this.dim + " path=" + Arrays.toString(this.path) + " bytes=" + String.valueOf(this.assoc) + ")";
    }

    static {
        TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        TYPE.freeze();
    }
}

