/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.document.Field;
import org.apache.lucene.ars_nouveau.document.FieldType;
import org.apache.lucene.ars_nouveau.document.ShapeDocValues;
import org.apache.lucene.ars_nouveau.document.ShapeField;
import org.apache.lucene.ars_nouveau.geo.Geometry;
import org.apache.lucene.ars_nouveau.index.DocValuesType;
import org.apache.lucene.ars_nouveau.index.IndexableFieldType;
import org.apache.lucene.ars_nouveau.search.Query;

public abstract class ShapeDocValuesField
extends Field {
    protected final ShapeDocValues shapeDocValues;
    protected static final FieldType FIELD_TYPE = new FieldType();

    ShapeDocValuesField(String name, ShapeDocValues shapeDocValues) {
        super(name, FIELD_TYPE);
        this.shapeDocValues = shapeDocValues;
        this.fieldsData = shapeDocValues.binaryValue();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IndexableFieldType fieldType() {
        return FIELD_TYPE;
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        return null;
    }

    public int numberOfTerms() {
        return this.shapeDocValues.numberOfTerms();
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation relation, Object ... geometries) {
        throw new IllegalStateException("geometry queries not yet supported on shape doc values for field [" + field + "]");
    }

    public abstract Geometry getCentroid();

    public abstract Geometry getBoundingBox();

    public ShapeField.DecodedTriangle.TYPE getHighestDimensionType() {
        return this.shapeDocValues.getHighestDimension();
    }

    protected abstract double decodeX(int var1);

    protected abstract double decodeY(int var1);

    static {
        FIELD_TYPE.setDocValuesType(DocValuesType.BINARY);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.freeze();
    }
}

