/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDelay;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectLaunch;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPull;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.EnumSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChimeraRageGoal
extends Goal {
    WildenChimera chimera;
    boolean finished;
    public int ticks;

    public ChimeraRageGoal(WildenChimera chimera) {
        this.chimera = chimera;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean isInterruptable() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.ticks;
        if (this.ticks >= 40) {
            this.finished = true;
        }
    }

    public void start() {
        super.start();
        this.chimera.rageTimer = 200;
        this.finished = false;
        this.ticks = 0;
        Networking.sendToNearbyClient(this.chimera.level, (Entity)this.chimera, (CustomPacketPayload)new PacketAnimEntity(this.chimera.getId(), WildenChimera.Animations.HOWL.ordinal()));
        this.chimera.resetCooldowns();
        this.chimera.removeAllEffects();
        this.chimera.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100 + 100 * this.chimera.getPhase(), 3));
        this.chimera.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 300 + 300 * this.chimera.getPhase(), this.chimera.getPhase()));
        LivingEntity target = this.chimera.getTarget();
        if (target != null && !target.onGround()) {
            target.removeEffect(MobEffects.SLOW_FALLING);
        }
        if (target != null) {
            EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.chimera.level, new Spell().add((AbstractSpellPart)MethodTouch.INSTANCE).add((AbstractSpellPart)EffectLaunch.INSTANCE).add((AbstractSpellPart)EffectDelay.INSTANCE).add((AbstractSpellPart)EffectPull.INSTANCE).add((AbstractSpellPart)AugmentAmplify.INSTANCE, 2).add((AbstractSpellPart)EffectGravity.INSTANCE).add((AbstractSpellPart)AugmentExtendTime.INSTANCE), (LivingEntity)this.chimera, new LivingCaster((LivingEntity)this.chimera)));
            resolver.onCastOnEntity(target);
            PortUtil.sendMessage((Entity)target, (Component)Component.translatable((String)"ars_nouveau.chimera.rage"));
        }
    }

    public boolean canContinueToUse() {
        return !this.finished;
    }

    public boolean canUse() {
        return this.chimera.getTarget() != null && this.chimera.rageTimer <= 0 && this.chimera.getPhase() > 0 && this.chimera.canRage();
    }
}

