/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.common.datagen.BlockTagProvider;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;

public class GoToBedGoal
extends Goal {
    boolean unreachable;
    public Starbuncle starbuncle;
    BlockPos bedPos;
    public StarbyBehavior behavior;
    public int ticksRunning;

    public GoToBedGoal(Starbuncle starbuncle, StarbyBehavior behavior) {
        this.starbuncle = starbuncle;
        this.behavior = behavior;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        if (this.ticksRunning >= 300) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("BedTimeout", "Took too long to find bed"));
            this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
            return false;
        }
        if (this.bedPos == null || this.starbuncle.data.bedPos == null) {
            return false;
        }
        boolean bedValid = true;
        boolean isOnBed = false;
        if (this.starbuncle.level.getGameTime() % 10L == 0L) {
            bedValid = this.isBedValid();
            isOnBed = this.isOnBed();
        }
        return !this.unreachable && bedValid && !isOnBed;
    }

    public void start() {
        super.start();
        this.unreachable = false;
        this.starbuncle.getNavigation().stop();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.RESTING;
        this.ticksRunning = 0;
        this.bedPos = this.starbuncle.data.bedPos;
    }

    public void stop() {
        super.stop();
        this.ticksRunning = 0;
    }

    public void tick() {
        super.tick();
        ++this.ticksRunning;
        this.setPath(this.bedPos.getX(), (double)this.bedPos.getY() + 1.0, this.bedPos.getZ(), 1.3);
        this.starbuncle.addGoalDebug(this, new DebugEvent("PathToBed", "Pathing to " + this.bedPos.getX() + " " + this.bedPos.getY() + " " + this.bedPos.getZ()));
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(BlockPos.containing((double)x, (double)y, (double)z), 1.3);
        if (this.starbuncle.getNavigation().getPath() != null && !this.starbuncle.getNavigation().getPath().canReach()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("BedUnreachable", "Unreachable"));
            this.unreachable = true;
        }
    }

    public boolean canUse() {
        boolean canRun;
        if (this.starbuncle.level.random.nextInt(2) == 0) {
            return false;
        }
        this.bedPos = this.starbuncle.data.bedPos;
        if (this.starbuncle.getBedBackoff() > 0 || this.starbuncle.goalState != Starbuncle.StarbuncleGoalState.NONE || this.bedPos == null || !this.behavior.canGoToBed()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("CannotSleep", "Bed not valid backoff: " + this.starbuncle.getBedBackoff()));
            return false;
        }
        boolean bl = canRun = this.isBedValid() && !this.isOnBed();
        if (!canRun) {
            this.starbuncle.setBedBackoff(60);
            this.starbuncle.addGoalDebug(this, new DebugEvent("InvalidBed", "Bed position invalid"));
        }
        return canRun;
    }

    public boolean isBedValid() {
        return this.starbuncle.level.isLoaded(this.bedPos) && this.starbuncle.level.getBlockState(new BlockPos((Vec3i)this.bedPos)).is(BlockTagProvider.SUMMON_SLEEPABLE);
    }

    public boolean isOnBed() {
        return this.starbuncle.level.getBlockState(BlockPos.containing((Position)this.starbuncle.position)).is(BlockTagProvider.SUMMON_SLEEPABLE);
    }

    public boolean isInterruptable() {
        return true;
    }
}

