/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.common.entity.ColoredProjectile;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntityRitualProjectile
extends ColoredProjectile {
    public BlockPos tilePos;

    public EntityRitualProjectile(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ENTITY_RITUAL.get()), worldIn, x, y, z);
    }

    public EntityRitualProjectile(Level worldIn, BlockPos pos) {
        super((EntityType<? extends ColoredProjectile>)((EntityType)ModEntities.ENTITY_RITUAL.get()), worldIn, pos.getX(), pos.getY(), pos.getZ());
    }

    public EntityRitualProjectile(EntityType<EntityRitualProjectile> entityAOEProjectileEntityType, Level world) {
        super(entityAOEProjectileEntityType, world);
    }

    public void tick() {
        block6: {
            block7: {
                BlockEntity blockEntity;
                super.tick();
                if (this.level.isClientSide()) break block6;
                if (this.tilePos == null || !((blockEntity = this.level.getBlockEntity(this.tilePos)) instanceof RitualBrazierTile)) break block7;
                RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
                if (tile.ritual != null) break block6;
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.xOld = this.getX();
        this.yOld = this.getY();
        this.zOld = this.getZ();
        this.setPos(this.getX(), this.getY() + Math.sin((double)this.level.getGameTime() / 10.0) / 10.0, this.getZ());
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.level.isClientSide) {
            double j;
            int counter = 0;
            for (j = 0.0; j < 3.0; j += 1.0) {
                if ((counter += this.level.random.nextInt(3)) % (((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId()) != 0) continue;
                this.level.addParticle(ParticleSparkleData.createData(this.getParticleColor()), (double)((float)this.position().x()) + Math.sin((double)this.level.getGameTime() / 3.0), (double)((float)this.position().y()), (double)((float)this.position().z()) + Math.cos((double)this.level.getGameTime() / 3.0), (double)(0.0225f * this.random.nextFloat()), (double)(0.0225f * this.random.nextFloat()), (double)(0.0225f * this.random.nextFloat()));
            }
            for (j = 0.0; j < 3.0; j += 1.0) {
                if ((counter += this.level.random.nextInt(3)) % (((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId() == 0 ? 1 : 2 * ((ParticleStatus)Minecraft.getInstance().options.particles().get()).getId()) != 0) continue;
                this.level.addParticle(ParticleSparkleData.createData(new ParticleColor(2, 0, 144)), (double)((float)this.position().x()) - Math.sin((double)this.level.getGameTime() / 3.0), (double)((float)this.position().y()), (double)((float)this.position().z()) - Math.cos((double)this.level.getGameTime() / 3.0), (double)(0.0225f * this.random.nextFloat()), (double)(0.0225f * this.random.nextFloat()), (double)(0.0225f * this.random.nextFloat()));
            }
        }
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_RITUAL.get();
    }

    public boolean save(CompoundTag tag) {
        if (this.tilePos != null) {
            tag.put("ritpos", NbtUtils.writeBlockPos((BlockPos)this.tilePos));
        }
        return super.save(tag);
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        if (compound.contains("ritpos")) {
            this.tilePos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"ritpos").orElse(null);
        }
    }
}

