/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.datagen.BiomeTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.BannerRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.WorldgenRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WorldgenProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, WorldgenRegistry::bootstrapConfiguredFeatures).add(Registries.PLACED_FEATURE, WorldgenRegistry::bootstrapPlacedFeatures).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifierRegistry::bootstrap).add(Registries.BIOME, BiomeRegistry::bootstrap).add(Registries.BANNER_PATTERN, BannerRegistry::bootstrapPatterns);

    public WorldgenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("ars_nouveau"));
    }

    public static class BiomeModifierRegistry {
        public static final ResourceKey<BiomeModifier> STARBUNCLE_SPAWN = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("starbuncle_spawn"));
        public static final ResourceKey<BiomeModifier> GIFT_STARBUNCLE_SPAWN = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("gift_starbuncle_spawn"));
        public static final ResourceKey<BiomeModifier> DRYGMY_SPAWN = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("drygmy_spawn"));
        public static final ResourceKey<BiomeModifier> ALARKINOS_SPAWN = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("alakarkinos_spawn"));
        public static final ResourceKey<BiomeModifier> WHIRLISPRIG_SPAWN = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("whirlisprig_spawn"));
        public static final ResourceKey<BiomeModifier> ARCHWOOD_MIX_RARE = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("rare_archwood_mix"));
        public static final ResourceKey<BiomeModifier> BERRY_COMMON = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("common_source_berry"));

        public static void bootstrap(BootstrapContext<BiomeModifier> context) {
            HolderSet.Named OVERWORLD_TAG = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
            HolderSet.Named BEACH_TAG = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_BEACH);
            HolderSet.Named BERRY_BIOMES = context.lookup(Registries.BIOME).getOrThrow(BiomeTagProvider.BERRY_SPAWN);
            Holder.Reference BERRY_SET = (Holder.Reference)context.lookup(Registries.PLACED_FEATURE).get(WorldgenRegistry.PLACED_BERRY_BUSH).get();
            Holder.Reference TREE_SET = (Holder.Reference)context.lookup(Registries.PLACED_FEATURE).get(WorldgenRegistry.PLACED_MIX_ARCHWOODS).get();
            context.register(STARBUNCLE_SPAWN, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STARBUNCLE_TYPE.get(), 5, 1, 2)));
            context.register(GIFT_STARBUNCLE_SPAWN, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GIFT_STARBY.get(), 1, 1, 1)));
            context.register(DRYGMY_SPAWN, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_DRYGMY.get(), 3, 1, 2)));
            context.register(WHIRLISPRIG_SPAWN, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), 5, 1, 2)));
            context.register(BERRY_COMMON, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)BERRY_BIOMES, (HolderSet)HolderSet.direct((Holder[])new Holder[]{BERRY_SET}), GenerationStep.Decoration.VEGETAL_DECORATION));
            context.register(ARCHWOOD_MIX_RARE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)OVERWORLD_TAG, (HolderSet)HolderSet.direct((Holder[])new Holder[]{TREE_SET}), GenerationStep.Decoration.VEGETAL_DECORATION));
            context.register(ALARKINOS_SPAWN, (Object)BiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)BEACH_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ALAKARKINOS_TYPE.get(), 5, 1, 1)));
        }

        @NotNull
        private static ResourceLocation prefix(String path) {
            return ArsNouveau.prefix(path);
        }
    }
}

