/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.item.inv.IInvProvider;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.RitualBrazierBlock;
import com.hollingsworth.arsnouveau.common.block.tile.BrazierRelayTile;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RitualBrazierTile
extends ModdedTile
implements ITooltipProvider,
GeoBlockEntity,
ILightable,
ITickable,
IInvProvider,
IDispellable,
IWandable {
    public AbstractRitual ritual;
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean isDecorative;
    public ParticleColor color = ParticleColor.defaultParticleColor();
    public boolean isOff;
    public BlockPos relayPos;
    public int sourceBackoff;

    public RitualBrazierTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public RitualBrazierTile(BlockPos p, BlockState s) {
        super((BlockEntityType)BlockRegistry.RITUAL_TILE.get(), p, s);
    }

    @Override
    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        BlockEntity blockEntity;
        if (storedPos != null && (blockEntity = this.level.getBlockEntity(storedPos)) instanceof BrazierRelayTile) {
            BrazierRelayTile relayTile = (BrazierRelayTile)blockEntity;
            if (BlockUtil.distanceFrom(this.getBlockPos(), storedPos) > 16.0) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.fail"));
                return;
            }
            this.relayPos = storedPos.immutable();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.brazier_relay.connected"));
            this.updateBlock();
        }
    }

    @Override
    public void onWanded(Player playerEntity) {
        if (this.relayPos != null) {
            this.relayPos = null;
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.connections.cleared"));
            this.updateBlock();
        }
    }

    @Override
    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        if (this.relayPos != null) {
            list.add(ColorPos.centered(this.relayPos, ParticleColor.TO_HIGHLIGHT));
        }
        return list;
    }

    public void makeParticle(ParticleColor centerColor, ParticleColor outerColor, int intensity) {
        BlockEntity blockEntity;
        int i;
        Level world = this.getLevel();
        BlockPos pos = this.getBlockPos();
        double xzOffset = 0.25;
        boolean isWeakFire = this.ritual != null && this.ritual.needsSourceNow();
        double centerYMax = isWeakFire ? 0.1 : 0.2;
        double outerYMax = isWeakFire ? 0.5 : 0.7;
        double ySpeed = isWeakFire ? (double)0.02f : (double)0.05f;
        intensity = isWeakFire ? intensity / 2 : intensity;
        for (i = 0; i < intensity; ++i) {
            world.addParticle(GlowParticleData.createData(centerColor.nextColor((int)this.level.getGameTime() * 10)), (double)pos.getX() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), (double)(pos.getY() + 1) + ParticleUtil.inRange(-0.05, centerYMax), (double)pos.getZ() + 0.5 + ParticleUtil.inRange(-xzOffset / 2.0, xzOffset / 2.0), 0.0, ParticleUtil.inRange(0.0, ySpeed), 0.0);
        }
        for (i = 0; i < intensity; ++i) {
            world.addParticle(GlowParticleData.createData(outerColor.nextColor((int)this.level.getGameTime() * 10)), (double)pos.getX() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), (double)(pos.getY() + 1) + ParticleUtil.inRange(0.0, outerYMax), (double)pos.getZ() + 0.5 + ParticleUtil.inRange(-xzOffset, xzOffset), 0.0, ParticleUtil.inRange(0.0, ySpeed), 0.0);
        }
        if (this.relayPos != null && (blockEntity = this.level.getBlockEntity(this.relayPos)) instanceof BrazierRelayTile) {
            BrazierRelayTile relayTile = (BrazierRelayTile)blockEntity;
            relayTile.makeParticle(centerColor, outerColor, intensity);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tick() {
        BlockEntity blockEntity;
        if (this.isDecorative && this.level.isClientSide) {
            this.makeParticle(this.color.nextColor((int)this.level.getGameTime() * 20), this.color.nextColor((int)this.level.getGameTime() * 20 + 200), 10);
            return;
        }
        if (this.level.isClientSide && this.ritual != null) {
            this.makeParticle(this.ritual.getCenterColor(), this.ritual.getOuterColor(), this.ritual.getParticleIntensity());
        }
        if (this.isOff) {
            return;
        }
        if (this.ritual == null) return;
        if (this.ritual.getContext().isDone) {
            this.ritual.onEnd();
            this.ritual = null;
            this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getLevel().getBlockState(this.getBlockPos()).setValue(RitualBrazierBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            this.updateBlock();
            return;
        }
        if (!this.ritual.isRunning() && !this.level.isClientSide && this.level.getGameTime() % 5L == 0L) {
            this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.getBlockPos()).inflate(1.0)).forEach(i -> this.tryBurnStack(i.getItem()));
        }
        if (this.ritual.consumesSource() && this.ritual.needsSourceNow()) {
            if (this.sourceBackoff-- > 0) return;
            int cost = this.ritual.getSourceCost();
            if (SourceUtil.takeSourceMultipleWithParticles(this.getBlockPos(), this.getLevel(), 6, cost) != null) {
                this.ritual.setNeedsSource(false);
                this.sourceBackoff = 0;
                this.updateBlock();
            } else {
                this.sourceBackoff = 20;
                return;
            }
        }
        if (this.relayPos != null && this.level.isLoaded(this.relayPos) && (blockEntity = this.level.getBlockEntity(this.relayPos)) instanceof BrazierRelayTile) {
            BrazierRelayTile relayTile = (BrazierRelayTile)blockEntity;
            this.ritual.tryTick(relayTile);
            relayTile.ticksToLightOff = 2;
            relayTile.isDecorative = false;
            return;
        } else {
            this.ritual.tryTick(this);
        }
    }

    public boolean takeSource() {
        if (this.ritual != null && this.ritual.consumesSource() && this.ritual.needsSourceNow()) {
            int cost = this.ritual.getSourceCost();
            if (SourceUtil.takeSourceMultipleWithParticles(this.getBlockPos(), this.getLevel(), 6, cost) != null) {
                this.ritual.setNeedsSource(false);
                this.updateBlock();
                return true;
            }
        }
        return false;
    }

    public boolean tryBurnStack(ItemStack stack) {
        if (this.ritual != null && !this.ritual.isRunning() && !this.level.isClientSide && this.ritual.canConsumeItem(stack)) {
            this.ritual.onItemConsumed(stack);
            ParticleUtil.spawnPoof((ServerLevel)this.level, this.getBlockPos());
            this.level.playSound(null, this.getBlockPos(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.3f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean isRitualDone() {
        return this.ritual != null && this.ritual.getContext().isDone;
    }

    @Deprecated(since="4.10.1", forRemoval=true)
    public boolean canRitualStart() {
        return this.ritual.canStart(null);
    }

    @Deprecated(since="4.10.1", forRemoval=true)
    public void startRitual() {
        this.startRitual(null);
    }

    public void startRitual(@Nullable Player player) {
        if (this.ritual == null || !this.ritual.canStart(player) || this.ritual.isRunning()) {
            return;
        }
        this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.ritual.onStart(player);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        String ritualIDString = tag.getString("ritualID");
        if (!ritualIDString.isEmpty()) {
            ResourceLocation ritualID = ResourceLocation.tryParse((String)ritualIDString);
            this.ritual = RitualRegistry.getRitual(ritualID);
            if (this.ritual != null) {
                this.ritual.tile = this;
                this.ritual.read(pRegistries, tag);
            }
        } else {
            this.ritual = null;
        }
        this.color = ParticleColorRegistry.from(tag.getCompound("color"));
        this.isDecorative = tag.getBoolean("decorative");
        this.isOff = tag.getBoolean("off");
        if (tag.contains("relayPos")) {
            this.relayPos = BlockPos.of((long)tag.getLong("relayPos"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.ritual != null) {
            tag.putString("ritualID", this.ritual.getRegistryName().toString());
            this.ritual.write(pRegistries, tag);
        } else {
            tag.remove("ritualID");
        }
        tag.put("color", (Tag)this.color.serialize());
        tag.putBoolean("decorative", this.isDecorative);
        tag.putBoolean("off", this.isOff);
        if (this.relayPos != null) {
            tag.putLong("relayPos", this.relayPos.asLong());
        }
    }

    public boolean canTakeAnotherRitual() {
        return this.ritual == null || this.ritual.isRunning();
    }

    public void setRitual(ResourceLocation selectedRitual) {
        this.ritual = RitualRegistry.getRitual(selectedRitual);
        if (this.ritual != null) {
            this.ritual.tile = this;
            Level world = this.getLevel();
            BlockState state = world.getBlockState(this.getBlockPos());
            world.setBlock(this.getBlockPos(), (BlockState)state.setValue(RitualBrazierBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.isDecorative = false;
        this.level.playSound(null, this.getBlockPos(), SoundEvents.FLINTANDSTEEL_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.updateBlock();
    }

    @Override
    public void getTooltip(List<Component> tooltips) {
        if (this.ritual != null) {
            tooltips.add((Component)Component.literal((String)this.ritual.getName()));
            if (this.isOff) {
                tooltips.add((Component)Component.translatable((String)"ars_nouveau.tooltip.turned_off").withStyle(ChatFormatting.GOLD));
                return;
            }
            if (!this.ritual.isRunning()) {
                if (!this.ritual.canStart(ArsNouveau.proxy.getPlayer())) {
                    tooltips.add((Component)Component.translatable((String)"ars_nouveau.tooltip.conditions_unmet").withStyle(ChatFormatting.GOLD));
                } else {
                    tooltips.add((Component)Component.translatable((String)"ars_nouveau.tooltip.waiting").withStyle(ChatFormatting.GOLD));
                }
            } else {
                tooltips.add((Component)Component.translatable((String)"ars_nouveau.tooltip.running"));
            }
            if (!this.ritual.getConsumedItems().isEmpty()) {
                tooltips.add((Component)Component.translatable((String)"ars_nouveau.tooltip.consumed"));
                for (String i : this.ritual.getFormattedConsumedItems()) {
                    tooltips.add((Component)Component.literal((String)i));
                }
            }
            if (this.ritual.needsSourceNow()) {
                tooltips.add((Component)Component.translatable((String)"ars_nouveau.wixie.need_mana").withStyle(ChatFormatting.GOLD));
            }
            this.ritual.modifyTooltips(tooltips);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats stats, SpellContext spellContext) {
        this.color = spellContext.getColors();
        this.isDecorative = true;
        BlockState state = world.getBlockState(this.getBlockPos());
        world.setBlock(this.getBlockPos(), (BlockState)state.setValue(RitualBrazierBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        this.updateBlock();
    }

    @Override
    public boolean onDispel(@Nullable LivingEntity caster) {
        if (!this.isDecorative) {
            return false;
        }
        this.isDecorative = false;
        this.level.setBlock(this.getBlockPos(), (BlockState)this.level.getBlockState(this.getBlockPos()).setValue(RitualBrazierBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
        this.updateBlock();
        return true;
    }

    @Override
    public InventoryManager getInventoryManager() {
        return InventoryManager.fromTile(this);
    }
}

