/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.inv.FilterSet;
import com.hollingsworth.arsnouveau.api.item.inv.IFiltersetProvider;
import com.hollingsworth.arsnouveau.api.item.inv.IMapInventory;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IResolveListener;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.RepositoryBlock;
import com.hollingsworth.arsnouveau.common.block.RepositoryCatalog;
import com.hollingsworth.arsnouveau.common.block.tile.ControllerInv;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.ItemScroll;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectName;
import com.hollingsworth.arsnouveau.setup.registry.BlockEntityTypeRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RepositoryCatalogTile
extends ModdedTile
implements ITooltipProvider,
ITickable,
Nameable,
GeoBlockEntity,
IFiltersetProvider,
IAnimationListener {
    public List<ConnectedRepository> connectedRepositories = new ArrayList<ConnectedRepository>();
    public ItemStack scrollStack = ItemStack.EMPTY;
    boolean invalidateNextTick;
    private int openDrawer = 0;
    private int drawerTicks = 0;
    public FilterSet proxyFilters = new ProxyFilterSet(this);
    public Component name;
    List<AnimationController> animControllers = new ArrayList<AnimationController>();
    AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RepositoryCatalogTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.REPOSITORY_CONTROLLER_TILE, pos, state);
    }

    public RepositoryCatalogTile(BlockEntityTypeRegistryWrapper<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public ItemStack setNewScroll(ItemStack stack) {
        ItemStack oldStack = this.scrollStack.copy();
        this.scrollStack = stack.copy();
        this.updateBlock();
        return oldStack;
    }

    @Override
    public FilterSet getFilterSet() {
        if (this.scrollStack.isEmpty()) {
            return this.proxyFilters;
        }
        FilterSet.ListSet listSet = new FilterSet.ListSet();
        listSet.addFilterScroll(this.scrollStack, this.getControllerInv());
        return new FilterSet.Composite().withFilter(listSet).withFilter(this.proxyFilters);
    }

    public void invalidateNetwork() {
        this.connectedRepositories = new ArrayList<ConnectedRepository>();
        this.buildRepositoryNetwork(new HashSet<BlockPos>(), this.worldPosition);
        this.invalidateCapabilities();
    }

    private void buildRepositoryNetwork(Set<BlockPos> visited, BlockPos nextPos) {
        Direction[] directionArray = this.level;
        if (!(directionArray instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)directionArray;
        visited.add(nextPos);
        for (Direction direction : Direction.values()) {
            BlockPos pos = nextPos.relative(direction);
            if (visited.contains(pos)) continue;
            visited.add(pos);
            if (!(this.level.getBlockState(pos).getBlock() instanceof RepositoryBlock)) continue;
            BlockCapabilityCache mapCap = BlockCapabilityCache.create(CapabilityRegistry.MAP_INV_CAP, (ServerLevel)serverLevel, (BlockPos)pos, (Object)direction, () -> !this.isRemoved(), () -> {
                this.invalidateNextTick = true;
            });
            BlockCapabilityCache invCap = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)serverLevel, (BlockPos)pos, (Object)direction, () -> !this.isRemoved(), () -> {
                this.invalidateNextTick = true;
            });
            this.connectedRepositories.add(new ConnectedRepository(pos, (BlockCapabilityCache<IMapInventory, Direction>)mapCap, (BlockCapabilityCache<IItemHandler, Direction>)invCap));
            this.buildRepositoryNetwork(visited, pos);
        }
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (this.hasCustomName()) {
            tooltip.add(this.getCustomName());
        }
        if (!this.scrollStack.isEmpty()) {
            tooltip.add((Component)this.scrollStack.getHoverName().copy().withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
            ItemScrollData scrollData = (ItemScrollData)this.scrollStack.get(DataComponentRegistry.ITEM_SCROLL_DATA);
            if (scrollData != null) {
                scrollData.addToTooltip(Item.TooltipContext.EMPTY, tooltip::add, (TooltipFlag)TooltipFlag.NORMAL);
            }
        }
    }

    @Override
    public void tick() {
        if (this.invalidateNextTick) {
            this.invalidateNetwork();
            this.invalidateNextTick = false;
        }
        if (this.drawerTicks > 0) {
            --this.drawerTicks;
            if (this.drawerTicks == 38) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.5f, 1.6f + (float)ParticleUtil.inRange(-0.2, 0.2));
            }
            if (this.drawerTicks == 15) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.5f, 1.6f + (float)ParticleUtil.inRange(-0.2, 0.2));
            }
            if (this.drawerTicks == 38 && !this.level.isClientSide) {
                Direction direction = (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)RepositoryCatalog.FACING);
                for (Entity entity : this.level.getEntities(null, AABB.unitCubeFromLowerCorner((Vec3)this.worldPosition.relative(direction).getBottomCenter()))) {
                    entity.push((double)direction.getStepX() * 0.5, 0.1, (double)direction.getStepZ() * 0.5);
                    entity.hurtMarked = true;
                }
            }
        } else {
            this.openDrawer = 0;
        }
    }

    public void openRandomDrawer() {
        this.openDrawer = this.level.random.nextIntBetweenInclusive(1, 6);
        this.drawerTicks = 60;
        if (!this.level.isClientSide) {
            Networking.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new PacketOneShotAnimation(this.worldPosition));
        }
    }

    public void onLoad() {
        super.onLoad();
        this.invalidateNextTick = true;
    }

    public ControllerInv getControllerInv() {
        ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
        for (ConnectedRepository connectedRepository : this.connectedRepositories) {
            IItemHandler handler = (IItemHandler)connectedRepository.itemHandler.getCapability();
            if (handler == null) continue;
            handlers.add(handler);
        }
        return new ControllerInv(this, handlers.toArray(new IItemHandler[0]));
    }

    public Component getName() {
        return this.name;
    }

    public void setName(Component name) {
        this.name = name;
    }

    public IResolveListener getSpellListener() {
        return new IResolveListener(){

            @Override
            public void onPostResolve(Level world, @NotNull LivingEntity shooter, HitResult result, Spell spell, SpellContext spellContext, AbstractEffect resolveEffect, SpellStats spellStats, SpellResolver spellResolver) {
                if (resolveEffect instanceof EffectName && spell.name() != null) {
                    RepositoryCatalogTile.this.setName((Component)Component.literal((String)spell.name()));
                }
            }
        };
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("name")) {
            this.name = Component.literal((String)tag.getString("name"));
        }
        this.scrollStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("scrollStack"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.name != null) {
            tag.putString("name", this.name.getString());
        }
        tag.put("scrollStack", this.scrollStack.saveOptional(registries));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        for (int index = 1; index < 7; ++index) {
            int finalIndex = index;
            AnimationController controller = new AnimationController((GeoAnimatable)this, "drawer" + index, 20, event -> {
                if (this.openDrawer == finalIndex) {
                    event.getController().setAnimation(RawAnimation.begin().thenPlay("drawer" + finalIndex));
                    return PlayState.CONTINUE;
                }
                event.getController().forceAnimationReset();
                return PlayState.STOP;
            });
            this.animControllers.add(controller);
            controllers.add(controller);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }

    @Override
    public void startAnimation(int arg) {
        for (AnimationController controller : this.animControllers) {
            controller.forceAnimationReset();
        }
        this.openRandomDrawer();
    }

    public static class ProxyFilterSet
    extends FilterSet {
        RepositoryCatalogTile tile;

        public ProxyFilterSet(RepositoryCatalogTile tile) {
            this.tile = tile;
        }

        @Override
        public ItemScroll.SortPref getHighestPreference(ItemStack stack) {
            PriorityQueue<ControllerInv.SortResult> preferencedStacks = this.tile.getControllerInv().preferredForStack(stack, false);
            if (preferencedStacks.isEmpty()) {
                return ItemScroll.SortPref.INVALID;
            }
            return preferencedStacks.peek().sortPref();
        }
    }

    public static class ConnectedRepository {
        public BlockPos pos;
        public BlockCapabilityCache<IMapInventory, Direction> capability;
        public BlockCapabilityCache<IItemHandler, Direction> itemHandler;

        public ConnectedRepository(BlockPos pos, BlockCapabilityCache<IMapInventory, Direction> capability, BlockCapabilityCache<IItemHandler, Direction> itemHandler) {
            this.pos = pos;
            this.capability = capability;
            this.itemHandler = itemHandler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectedRepository that = (ConnectedRepository)o;
            return Objects.equals(this.pos, that.pos);
        }

        public int hashCode() {
            return Objects.hashCode(this.pos);
        }
    }
}

