/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.shader;

import com.hollingsworth.arsnouveau.client.shader.Texture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class FixedMultiTextureStateShard
extends RenderStateShard.EmptyTextureStateShard {
    private final Optional<ResourceLocation> cutoutTexture;

    public FixedMultiTextureStateShard(List<Texture> textures) {
        super(() -> {
            int i = 0;
            for (Texture texture : textures) {
                TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
                texturemanager.getTexture(texture.location()).setFilter(texture.blur(), texture.mipmap());
                RenderSystem.setShaderTexture((int)i, (ResourceLocation)texture.location());
                if (i == 0) {
                    i = 3;
                    continue;
                }
                ++i;
            }
        }, () -> {});
        this.cutoutTexture = textures.stream().findFirst().map(Texture::location);
    }

    @NotNull
    protected Optional<ResourceLocation> cutoutTexture() {
        return this.cutoutTexture;
    }
}

